/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeDragAndDropEffect
extends DragAndDropEffect {
    Tree tree;
    int currentEffect = 0;
    TreeItem currentItem;
    TreeItem insertItem = null;
    boolean insertBefore = false;
    TreeItem scrollItem;
    long scrollBeginTime;
    TreeItem expandItem;
    long expandBeginTime;
    static Callback AcceptDragProc;
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 300;
    static /* synthetic */ Class class$0;

    static {
        int acceptDragProc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.TreeDragAndDropEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acceptDragProc = (AcceptDragProc = new Callback(clazz, "AcceptDragProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    TreeDragAndDropEffect(Tree tree) {
        this.tree = tree;
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(tree.handle, callbacks);
        callbacks.v1_acceptDragCallback = AcceptDragProc.getAddress();
        OS.SetDataBrowserCallbacks(tree.handle, callbacks);
    }

    static int AcceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        DropTarget target = TreeDragAndDropEffect.FindDropTarget(theControl, theDrag);
        if (target == null || target.effect == null) {
            return 0;
        }
        TreeDragAndDropEffect effect = (TreeDragAndDropEffect)target.effect;
        return effect.acceptDragProc(theControl, itemID, property, theRect, theDrag);
    }

    static DropTarget FindDropTarget(int theControl, int theDrag) {
        if (theControl == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(theControl);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    int acceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        return (this.currentEffect & 1) != 0 ? 1 : 0;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TreeItem item = this.tree.getItem(coordinates = this.tree.toControl(coordinates));
        if (item == null && (area = this.tree.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.tree.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    TreeItem nextItem(TreeItem item) {
        int count;
        if (item == null) {
            return null;
        }
        if (item.getExpanded()) {
            return item.getItem(0);
        }
        TreeItem childItem = item;
        TreeItem parentItem = childItem.getParentItem();
        int index = parentItem == null ? this.tree.indexOf(childItem) : parentItem.indexOf(childItem);
        int n = count = parentItem == null ? this.tree.getItemCount() : parentItem.getItemCount();
        while (index + 1 >= count) {
            if (parentItem == null) {
                return null;
            }
            childItem = parentItem;
            index = (parentItem = childItem.getParentItem()) == null ? this.tree.indexOf(childItem) : parentItem.indexOf(childItem);
            count = parentItem == null ? this.tree.getItemCount() : parentItem.getItemCount();
        }
        return parentItem == null ? this.tree.getItem(index + 1) : parentItem.getItem(index + 1);
    }

    TreeItem previousItem(TreeItem item) {
        int index;
        if (item == null) {
            return null;
        }
        TreeItem childItem = item;
        TreeItem parentItem = childItem.getParentItem();
        int n = index = parentItem == null ? this.tree.indexOf(childItem) : parentItem.indexOf(childItem);
        if (index == 0) {
            return parentItem;
        }
        TreeItem nextItem = parentItem == null ? this.tree.getItem(index - 1) : parentItem.getItem(index - 1);
        int count = nextItem.getItemCount();
        while (count > 0 && nextItem.getExpanded()) {
            nextItem = nextItem.getItem(count - 1);
            count = nextItem.getItemCount();
        }
        return nextItem;
    }

    void setInsertMark(TreeItem item, boolean before) {
        if (item == this.insertItem && before == this.insertBefore) {
            return;
        }
        this.insertItem = item;
        this.insertBefore = before;
        this.tree.setInsertMark(item, before);
    }

    void showDropTargetEffect(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        TreeItem item = (TreeItem)this.getItem(x, y);
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
        } else if (item != null && item.equals(this.expandItem) && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (item.getItemCount() > 0 && !item.getExpanded()) {
                    Event event = new Event();
                    event.x = x;
                    event.y = y;
                    event.item = item;
                    event.time = (int)System.currentTimeMillis();
                    this.tree.notifyListeners(17, event);
                    if (item.isDisposed()) {
                        return;
                    }
                    item.setExpanded(true);
                }
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 300L;
            this.expandItem = item;
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                Rectangle area = this.tree.getClientArea();
                int headerHeight = this.tree.getHeaderHeight();
                int itemHeight = this.tree.getItemHeight();
                Point pt = new Point(x, y);
                pt = this.tree.getDisplay().map(null, (Control)this.tree, pt);
                TreeItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    nextItem = this.previousItem(item);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    nextItem = this.nextItem(item);
                }
                if (nextItem != null) {
                    this.tree.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        if ((effect & 4) != 0 || (effect & 2) != 0) {
            if (this.currentItem != item || (effect & 4) != (this.currentEffect & 4) || (effect & 2) != (this.currentEffect & 2)) {
                this.setInsertMark(item, (effect & 2) != 0);
                this.currentEffect = effect;
                this.currentItem = item;
            }
        } else {
            this.setInsertMark(null, false);
        }
        this.currentEffect = effect;
    }
}

