/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell parent) {
        this(parent, 32768);
    }

    public PrintDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public PrinterData open() {
        int[] buffer = new int[1];
        if (OS.PMCreateSession(buffer) == 0) {
            int printSession = buffer[0];
            if (OS.PMCreatePrintSettings(buffer) == 0) {
                int printSettings = buffer[0];
                OS.PMSessionDefaultPrintSettings(printSession, printSettings);
                if (OS.PMCreatePageFormat(buffer) == 0) {
                    int pageFormat = buffer[0];
                    OS.PMSessionDefaultPageFormat(printSession, pageFormat);
                    OS.PMSessionSetDestination(printSession, printSettings, (short)(this.printToFile ? 2 : 1), 0, 0);
                    if (this.scope == 1) {
                        OS.PMSetFirstPage(printSettings, this.startPage, false);
                        OS.PMSetLastPage(printSettings, this.endPage, false);
                        OS.PMSetPageRange(printSettings, this.startPage, this.endPage);
                    } else {
                        OS.PMSetPageRange(printSettings, 1, Integer.MAX_VALUE);
                    }
                    boolean[] accepted = new boolean[1];
                    OS.PMSessionPageSetupDialog(printSession, pageFormat, accepted);
                    if (accepted[0]) {
                        OS.PMSessionPrintDialog(printSession, printSettings, pageFormat, accepted);
                        if (accepted[0]) {
                            short[] destType = new short[1];
                            OS.PMSessionGetDestinationType(printSession, printSettings, destType);
                            String name = Printer.getCurrentPrinterName(printSession);
                            String driver = "Mac";
                            switch (destType[0]) {
                                case 3: {
                                    driver = "Fax";
                                    break;
                                }
                                case 2: {
                                    driver = "File";
                                    break;
                                }
                                case 4: {
                                    driver = "Preview";
                                    break;
                                }
                                case 1: {
                                    driver = "Printer";
                                }
                            }
                            PrinterData data = new PrinterData(driver, name);
                            if (destType[0] == 2) {
                                data.printToFile = true;
                                OS.PMSessionCopyDestinationLocation(printSession, printSettings, buffer);
                                int fileName = OS.CFURLCopyFileSystemPath(buffer[0], 0);
                                OS.CFRelease(buffer[0]);
                                data.fileName = Printer.getString(fileName);
                                OS.CFRelease(fileName);
                            }
                            OS.PMGetCopies(printSettings, buffer);
                            data.copyCount = buffer[0];
                            OS.PMGetFirstPage(printSettings, buffer);
                            data.startPage = buffer[0];
                            OS.PMGetLastPage(printSettings, buffer);
                            data.endPage = buffer[0];
                            OS.PMGetPageRange(printSettings, null, buffer);
                            data.scope = data.startPage == 1 && data.endPage == Integer.MAX_VALUE ? 0 : 1;
                            boolean[] collate = new boolean[1];
                            OS.PMGetCollate(printSettings, collate);
                            data.collate = collate[0];
                            int[] flatSettings = new int[1];
                            OS.PMFlattenPrintSettings(printSettings, flatSettings);
                            int[] flatFormat = new int[1];
                            OS.PMFlattenPageFormat(pageFormat, flatFormat);
                            int settingsLength = OS.GetHandleSize(flatSettings[0]);
                            int formatLength = OS.GetHandleSize(flatFormat[0]);
                            data.otherData = new byte[settingsLength + formatLength + 8];
                            byte[] otherData = data.otherData;
                            int offset = 0;
                            offset = Printer.packData(flatSettings[0], otherData, offset);
                            offset = Printer.packData(flatFormat[0], otherData, offset);
                            OS.DisposeHandle(flatSettings[0]);
                            OS.DisposeHandle(flatFormat[0]);
                            this.scope = data.scope;
                            this.startPage = data.startPage;
                            this.endPage = data.endPage;
                            this.printToFile = data.printToFile;
                            return data;
                        }
                    }
                    OS.PMRelease(pageFormat);
                }
                OS.PMRelease(printSettings);
            }
            OS.PMRelease(printSession);
        }
        return null;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean printToFile) {
        this.printToFile = printToFile;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            SWT.error(43);
        }
    }
}

