#!/usr/bin/python
# -*- coding: utf-8 -*-

#
# Copyright 2011, The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

if __name__ == "__main__":
    externs = []
    lines = open("../../../frameworks/base/opengl/libs/enums.in").readlines()
    output = open("src/com/android/glesv2debugger/GLEnum.java", "w")
    i = 0
    output.write(
"""/*
 ** Copyright 2011, The Android Open Source Project
 **
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 **
 **     http://www.apache.org/licenses/LICENSE-2.0
 **
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 */

// auto generated by generate_GLEnum_java.py"

package com.android.glesv2debugger;

public enum GLEnum {
""")
    
    index = 0
    for line in lines:
        value = line[line.find("(") + 1: line.find(",")]
        name = line[line.find(",") + 1: line.find(")")]    
        output.write("    %s(%s),\n" % (name, value))

    output.write("""    ;

    public final int value;
    GLEnum(final int value) {
        this.value = value;
    }

    private static final java.util.HashMap<Integer, GLEnum> reverseMap = new java.util.HashMap<Integer, GLEnum>();
    static {
        for (GLEnum e : GLEnum.values())
        reverseMap.put(e.value, e);
    }

    public static GLEnum valueOf(final int value) {
        return reverseMap.get(value);
    }
}""")


