Ateles
======

(Adaptive Tree based Efficient and Lithe Equation Solver)

Ateles implements a high-order modal/nodal discontinuous Galerkin solver within
the APES suite.
It is working on a linearized octree and uses efficient data structures
for large scale parallel computations.
Cubical elements allow for efficient numerical schemes, while geometries
can be represented with a penalization method within the elements.

Documentation
-------------

The documentation is generated with
[FORD](https://github.com/Fortran-FOSS-Programmers/ford), and
[available online](https://geb.sts.nt.uni-siegen.de/doxy/ateles/index.html).
You can also generate the documentation with `waf gendoxy`, configuration
of FORD is detailed in `mainpage.md`.

How to compile
--------------

Ateles uses [waf](http://waf.io) to organize the compilation process.

You will need to have an MPI wrapper for your Fortran compiler and have
the environment variable *FC* set to it.
Usually this is:

    export FC=mpif90

The compilation can then be configured for your system by

    ./waf configure

and the executable can then be built with

    ./waf build

Please use the `--help` option to get more details on the available parameters
for the compilation.


How to run
----------

Ateles, like the other tools in the APES suite, uses Lua scripts for the
configuration. A sample configuration is available in `ateles.lua`. Run
ateles by providing it as sole argument the configuration file to use.
If you do not provide any argument, the solver will attempt to use
the file `ateles.lua` in the current directory and fails if it is not
present.

License
-------

Ateles is freely available under the terms of the
[ISC License](https://opensource.org/licenses/ISC).
Please see the *COPYRIGHT* file for more details.
