-- Configuration file for Ateles --
logging = {level = 10}

timestep_info = 10

-- ...the length of the cube
cubeLength = 2.0

-- the refinement level of the octree
level = 2

-- Transport velocity of the pulse in x direction.
velocityX = 100

-- global simulation options
simulation_name = 'gPulseDens_euler_modg' -- the name of the simualtion
sim_control = {
  time_control = {
    min = 0,
    max = 0.0007 -- final simulation time
  }
}

characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  -- This is the global material for Euler 3D. It consists of three different 
  -- components, characteristics with one scalar, relax_velocity with three 
  -- scalars and relax_temperature with one scalar, thus we need five scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a 
  -- neutral term, which in this case is 0.
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 3,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  }
}

-- Mesh definitions --
mesh = {
  predefined = 'cube',
  origin = {
    (-1.0)*cubeLength/2.0,
    (-1.0)*cubeLength/2.0,
    (-1.0)*cubeLength/2.0
  },
  length = cubeLength,
  refinementLevel = level
}


---- Restart settings
estart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/',                                        
            -- temporal definition of restart write
            time_control = {   
              min = 0, 
              max = sim_control.time_control.max, 
              interval = sim_control.time_control.max/8.0
            }
          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
  folder = './',                  -- the folder for the timing results
  filename = 'timing.res'         -- the filename of the timing results
}

-- Equation definitions --
equation = {
  name = 'euler',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  r = 296.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',           -- we use the modal discontinuous Galerkin scheme 
    m = 7,                   -- the maximal polynomial degree for each spatial direction
    -- dealiasFactor = 1.0,     -- factor to remove aliases: 1.0 means no additional dealiasing
    -- blocksize = 32,          -- The minimal blocksize for the FPT 
    -- fftMultiThread = true,   -- Use multithreaded version of FFTW.
  },
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitRungeKutta',  --'explicitEuler',
    steps = 4,
    -- how to control the timestep
    control = {
      name = 'cfl',   -- the name of the timestep control mechanism
      cfl  = 0.9,     -- Courant-Friedrichs-Lewy number
    }
  }
}

function dens(x,y,z)
  return x
end

projection = {
  kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
                 -- for fpt the  nodes are automatically 'chebyshev'
                 -- for lep the  nodes are automatically 'gauss-legendre'
  -- lobattoPoints = false  -- if lobatto points should be used, default = false
  factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
  blocksize = 32,        -- for fpt, default -1
  fftMultiThread = false -- for fpt, logical, default false
}
-- This is a very simple example to define constant boundary condtions.
initial_condition = { 
  density = {
    predefined='gausspulse',
    center={0.0, 0.0, 0.0},
    halfwidth=0.20,
    amplitude=2.0,
    background=1.225
  },
  -- pressure = {
  --              predefined='gausspulse',
  --              center={0.0, 0.0, 0.0},
  --              halfwidth=0.2,
  --              amplitude=2.0,
  --              background=100000
  --            },
  pressure = 100000, 
  velocityX = velocityX,
  velocityY = 0,
  velocityZ = 0,
  -- projOverSampling =  1,    -- oversampling for quadrature projeciton of ini cond (per direction)
  -- useFpt = true,            -- use Fast polynomial transformation to convert to modal representation
}


-- Tracking
tracking = {
  label = 'track_ke',
  folder = './',
  variable = { 'momentum', 'velocity', 'density', 'kinetic_energy' },
  shape = {
    kind = 'canoND',
    object= { 
      origin ={ 0., 0., 0. }
    }
  },
  time_control = {
    min = 0,
    max = 0.005,
    interval = sim_control.time_control.max/10
  },
  output = { format = 'ascii', ndofs = 1 }, -- 'asciiSpatial', 'harvester', 'convergence'
}
