--------------------------------------------------------------------------------
-- Parameters to vary --
degree = 12
poly_space = 'Q'
-- ...the uniform refinement level for the periodic cube
level = 2

logging = { level = 4 }
-- Check for Nans and unphysical values
check =  {
           interval = 1,
         }

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

--...Configuration of simulation time
sim_control = { 
                time_control = { max = 0.2, -- final Simulated time
                                 min = 0.0, 
                                 interval = {iter = 1} 
                                }
              }

--...Configuration for the restart file
NOrestart = { 
            -- file to restart from
--            read = './restart/simulation_lastHeader.lua',                        
--            -- folder to write restart data to
            write = 'restart_2d/',
            -- temporal definition of restart write
            time_control = { max = sim_control.time_control.max,  -- final Simulated time
                             min = 0,
                             interval = 0.0005, --sim_control.time_control.max/50.0 
                            }
          }

-- End  Parameters to vary --
--------------------------------------------------------------------------------
-- Definition of the test-case.

-- Mesh definitions --
cubeLength = 2.0
level = 2.0
mesh = { predefined = 'slice',
         origin = { 
                    (-1.0)*cubeLength/2.0,
                    (-1.0)*cubeLength/2.0,
                    0.0 
                  },
         length = cubeLength,
         refinementLevel = level
       }

-- Tracking              
eps=cubeLength/(2^(level+1))
tracking = {
             label = 'track_2d_density_temporalBackground',
             folder = './',
             variable = {'density', 'completeState'},
             shape = {kind = 'canoND', object= { origin = {0.0,0.0,0.0}, 
                                               --  vec = { {cubeLength-eps,0.0,0.0}},
                                               --  segments = {200},
                                               --  distribution='equal'
                                                }
             },
             time_control = { max = sim_control.time_control.max,  -- final Simulated time
                             min = 0,
                             interval = sim_control.time_control.max/20.0 
                            },
             output = { format = 'ascii', ndofs = 1 }
           }

background_dens = 1.0
background_velX = 100.0
background_press = 2.0

function sinus_dens(t)
  return (background_dens + 0.5*math.sin(t*2*math.pi))
end

function sinus_velX(t)
  return (background_velX + 0.1*math.sin(t*2*math.pi) )
end

function sinus_press(t)
  return (background_press + 0.5*math.sin(t*2*math.pi))
end 

-- Equation definitions --
equation = {
  name   = 'LinearEuler_2d',
  isen_coef = 1.4,
  background = {
    density   = sinus_dens,
    velocityX = sinus_velX,
    velocityY = 0.0,
    pressure  = sinus_press,
  }
}

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg_2d',            -- we use the modal discontinuous Galerkin scheme 
               m =  degree,                   -- the maximal polynomial degree for each spatial direction
               modg_space = poly_space
               }, 
    -- the temporal discretization scheme
    temporal = {
                 name = 'explicitRungeKutta', 
                 steps = 4,
              -- how to control the timestep
                 control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.95,     -- CourantÐFriedrichsÐLewy number
                         },
               },
             }


-- variables for gaussian pluse             
c = math.sqrt(equation.isen_coef* background_press / background_dens)
ampl_density= background_dens/c 
ampl_pressure= background_press/c 

function init_density(x,y,z)
if x<0 then
  return(0.0)
else
  return(1.0)
end
end

function gaus_dens(x,y,z)
d= (x*x)+(y*y)
  return( ampl_density* math.exp(-d/0.01*math.log(2)) )
end

function ic_gauss_density(x,y,z)
d= x*x+y*y
return( 0.1 * math.exp(-d/0.01*math.log(2)) )
end

function ic_gauss_pressure(x,y,z)
d= x*x+y*y
return( ampl_pressure * math.exp(-d/0.01*math.log(2)) )
end

velx = 100

-- Initial Condition definitions --
initial_condition = { 
                --      density = ic_gauss_density,
                      density = 0.0,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      pressure = 0.0 --ic_gauss_pressure, 
                    }

