-- Use the configuration of the original simulation run.
-- (to get the equation table properly defined).
require 'ateles'
-- Logging level, required to be > 3 since harvester takes the written
-- time to generate the output name and create the pvd file
logging = {level=3}

-- Set the restart data to harvest.
restart.read = 'restart_sample_lastHeader.lua'


-- Subsampling for tracking, define a ply_sampling table to activate subsampling
-- for all tracking objects (except those with use_get_point):
-- Note, if you do set nlevels to 0, there will be no subsampling, and
-- only the first degree of freedom in the original mesh will be written out.
ply_sampling = {
  nlevels = 3,    -- maximal level to use in subsampling
                  -- defaults to 0, which deactivates subsampling

  --method  = 'fixed', -- method to use for subsampling
                       -- 'fixed': will refine all elements by
                       --  nlevels, default
                       -- 'adaptive': adaptive refinement of the
                       --  mesh based on solution.
                     -- Values for 'adaptive' case:
  --tolerance = 0.1, -- 'tolerance': value for the variation of
                     --  the solution representet in an element,
                     --  decision if an element will be refined
                     --  is based on this value.
  --dof_reduction = 0.5, -- 'dof_reduction': Reduction of degrees
                         --  of freedom to avoid too drastic
                         --  increase in memory consumption,
                         --  0.5 means half the polynomial degree
                         --  in every sampling step, 1.0 means no
                         --  dof_reduction.
  --adaptiveDofReduction = false,
                        -- 'adaptiveDofReduction': The dofs will
                        --  be reduced adaptively based on the
                        --  number of elements that will be
                        --  refined in the current sampling step,
                        --  minimum is 'dof_reduction'.
  --absUpperBoundLevel = 0 -- 'absUpperBoundLevel': Every element
                           --  on or above this level won't be
                           --  refined, suitable for
                           --  multi-level-meshes.
}

-- Example tracking to generate vtk files:
tracking = {
  { label = 'visu',
    variable = {'displacement_field','magnetic_field'},
    shape = {kind='global'},
    folder = 'harvest_',
    -- output format
    -- write_pvd=false important to create complete pvd file by harvester
    -- and not single pvd files by the solver
    output = {format = 'vtk', write_pvd=false}
  }
}
