-- Configuration file for Ateles --

require('seeder')

--p_refine = 2*2
p_refine = 1

--logging = { level = 20 }

radialconstant = 11.734936

-- global simulation options
sim_control = {
              name = 'maxwell',
              time_control = {
                                
                               --min = 100.0*math.pi/radialconstant,
                               -- min = 0.0,
                               max = 800.0*math.pi/radialconstant,
                               interval = {iter = 1000},
                             }
             }

-- Mesh definitions --
mesh = 'mesh/'

-- Restart settings
restart = { 
            --read = './restartlast002/simulation_lastHeader.lua', 
            write = './restart/',                                        
            time_control = {   
                             --min = 0.0, 
                             --min = sim_control.time_control.min, 
                             max = sim_control.time_control.max, 
                             interval = sim_control.time_control.max/100,
                   },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
-- ... material parameters inside te circle
cube_permea_circ = 1.0
cube_permit_circ = 1.0
-- ... material parameters of the background material
cube_permea_back = 1.0
cube_permit_back = 1.0
--cube_conduc_back = 4*p_refine*p_refine*10000.0
cube_conduc_back = 4*p_refine*p_refine*1000.0
--cube_conduc_back = 5*p_refine*p_refine*10000.0
print('Conductivity: ', cube_conduc_back)
-- ... the center of the circle
x_circle_center = 0.0 
y_circle_center = 0.0 
radius = 1.0
function permeability_permitivity(x,y,z,t)
  -- Calculate the distance from the circle center
  dist = math.sqrt( math.pow(x-x_circle_center,2.0) + math.pow(y-y_circle_center,2.0) )
  -- Check if the point is inside the circle
  if dist <= radius  then
    return { cube_permea_circ, cube_permit_circ, 0.0 }
  else
    return { cube_permea_back, cube_permit_back, cube_conduc_back }
  end 
end
equation = {
    name   = 'maxwell_2d',                 
    material = {
                 {
                    kind = 'lua_fun',
                    fun = permeability_permitivity,
                    shape={ 
                              kind = 'canoND', 
                              object = {
                                         origin = {-cubeLength/2,-cubeLength/2,-cubeLength/2},
                                         vec = {
                                                  {cubeLength,0.0,0.0},
                                                  {0.0,cubeLength,0.0},
                                                  {0.0,0.0,cubeLength},
                                               },
                                         segments = {
                                                     2*cubeLength/elemsize,
                                                     2*cubeLength/elemsize,
                                                     2*cubeLength/elemsize
                                                    },
                                       },
                          },
                 },
                 -- The background permitivity and permeability
                 global = {
                            kind = 'const',
                            const = {cube_permea_circ, cube_permit_circ, 0.0},
                          },
               }, 
}

-- Check for Nans and unphysical values
check =  {
           interval = 1,
         }

-- Scheme definitions --
scheme = {
    spatial =  {
               name = 'modg_2d',          
               m = p_refine*31 ,                  
               modg_space = 'Q' 
               }, 
    temporal = {
               name = 'explicitRungeKutta', 
               steps = 4,
               control = {
                          name = 'cfl', 
                          cfl  = 0.1,  
                         },
               },
}

-- ...the initial condition table. 
initial_condition = { 
                      displacement_fieldX = 0.0,
                      displacement_fieldY = 0.0,
                      magnetic_field      = 0.0,
                    }

-- ...the general projection table
projection = {
              kind = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Tracking
tracking = {
              label = 'probe_displacementField_Q8',
              folder = './tracking/',
              variable = {'displacement_field'},
              track_complete_element = false,
              shape = {
                       kind = 'canoND',
                       object= { origin =
                                 {-0.25,-0.25,0.0},
                               },
                      },
              time_control = {
                min = 0,
                max = sim_control.time_control.max,
                interval = {iter=1}
              },
              format = 'ascii',
              }
                    

-- The definition of the current density
x_center = 0.0
y_center = 0.0
-- ... pulse width in the x and y direction
width = 0.00125
-- ... peak-value of the current density
curConst = 1.0
-- ... the temporal mode
-- ... w is calculated from the mid point of first 2 TE modes
w = 0.38956522533293
-- ... width of the temporal ramping 
widthTime = 0.05
-- ... the starting point of the temporal ramping
t_center = -0.1 -- TODO -2.0
function current(x,y,z,t)
  r =  (x-x_center)^2.0 + (y-y_center)^2.0 
  tRamp = ( math.tanh( (t + t_center ) / widthTime ) + 1 ) / 2.0
  cur = curConst * math.exp( -r/width ) * math.sin( 2.0*math.pi*w*t ) * tRamp
  return { 0.0, cur }
end 
-- Source terms
source = {
  currentDensity = {
    fun = current
  }
}
