-- Configuration file for Ateles --

-- The number of MPI ranks (for parallel excution)
nprocs = 1

-- The analytic solution of this testcase.
-- ... the magnetic permability
perma = 1
-- ... the displacement permitivity
permit = 1
-- .. speed of light
cl = 1.0/math.sqrt(perma * permit)
-- ... the number of the z mode
k = 1
m = 2*math.pi*k/2.5
-- ... temporal angular frequency (2.5 is the length in z direction of the waveguide)
w = m*cl
-- ... the temporal period of the coaxial wave guide
T = 2.0*math.pi/w
-- ... displacement field - x component 
function displacementX(x,y,z,t)
  return (x/(x^2+y^2))*math.sin(m*z-w*t)
end
-- ... displacement field - y component 
function displacementY(x,y,z,t)
  return (y/(x^2+y^2))*math.sin(m*z-w*t)
end
-- ... displacement field - z component 
function displacementZ(x,y,z,t)
  return 0.0
end
-- ... magnetic field - x component
function magneticX(x,y,z,t)
  return (1/cl)*((-y)/(x^2+y^2))*math.sin(m*z-w*t)
end 
-- ... magnetic field - y component
function magneticY(x,y,z,t)
  return (1/cl)*((x)/(x^2+y^2))*math.sin(m*z-w*t)
end 
-- ... magnetic field - z component
function magneticZ(x,y,z,t)
  return 0.0 
end 

-- global simulation options
simulation_name = 'coaxialwaveguide_maxwell_weno' -- the name of the simualtion
sim_control = {
                time_control = { 
                  max = 0.1 -- final simulation time
                }
              }

--commpattern = 'gathered_type'

-- Mesh definitions --
mesh = './mesh/'

-- Restart settings
--restart = { 
--            -- If this table is available it will read the restart file
--            -- given below.
--            read =  {
--                     folder    = './restart/maxwell/',                           -- folder of the restart file
--                     file_name = 'lastHeader.lua'                                -- the restart file to read
--                    },
--            -- If this table is available it will write a restart file
--            -- with the specified options.
--            write = {
--                     folder    = './restart/maxwell/',                           -- the folder the restart files are written to
--                     interval  = 2.5/10.0,                                      -- dump restart file interval
--                     tmin      = 0.0,                                            -- first timestep to output
--                     tmax      = 20.0                                            -- last timestep to output
--                    }
--          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }


-- Equation definitions --
equation = {
    name   = 'maxwell',                             -- we solve maxwell's equations
    material     = {
                         -- The background permitivity and permeability
                         global = {
                                    kind = 'const',
                                    const = {permea, permit, 0.0},
                                  },
                       },
}

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'weno',            -- we use the weno scheme for reconstruction
               m = 1,                     -- the reconstructed polynomial is of degree 1
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.3,     -- CourantFriedrichsLewy number
                         },
               },
}

-- ...initial condition function for displacement field 
function ic_displacementX(x,y,z)
  return displacementX(x,y,z,0)
end
function ic_displacementY(x,y,z)
  return displacementY(x,y,z,0)
end
function ic_displacementZ(x,y,z)
  return displacementZ(x,y,z,0)
end
-- ...initial condition function for magnetic field 
function ic_magneticX(x,y,z)
  return magneticX(x,y,z,0)
end
function ic_magneticY(x,y,z)
  return magneticY(x,y,z,0)
end
function ic_magneticZ(x,y,z)
  return magneticZ(x,y,z,0)
end
-- ...the initial condition table
initial_condition = { 
                      displacement_fieldX = ic_displacementX,  -- displacement field , x component
                      displacement_fieldY = ic_displacementY,  -- displacement field , y component
                      displacement_fieldZ = ic_displacementZ,  -- displacement field , z component
                      magnetic_fieldX = ic_magneticX,  -- magnetic induction , x component
                      magnetic_fieldY = ic_magneticY,  -- magnetic induction , y component
                      magnetic_fieldZ = ic_magneticZ,  -- magnetic induction , z component
                    }


-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'innerCylinder',   -- boundary for the inner cylinder
                       kind = 'pec',              -- perfectly electric conductor
                       }
                       ,
                       { 
                       label = 'outerCylinder',   -- boundary for the outer cylinder
                       kind = 'pec',              -- perfectly electric conductor
                       }
                     }  

