folder = 'mesh/'
comment = 'Coaxial wave guide'

-- The global refinement level of the mesh
minlevel = 7

-- Bounding cube: the root node of the octree, defining the complete universe,
-- from which all elements are derived by recursive bisection.
-- The origin is the corner from which on the cube is spanned with the given
-- length in each direction.
bounding_cube = { origin = {-1.5, -1.5, -1.5},
                  length = 3.0 }

spatial_object = {
  { -- Define the wave guide with the help of two STL files
    attribute = { kind = 'boundary',
                  label = 'innerCylinder',
                  level = minlevel
                },
    geometry = { kind = 'stl',
                 object = { filename = 'innerCylinder.stl' }
               }
  },
  { -- Define the wave guide with the help of two STL files
    attribute = { kind = 'boundary',
                  label = 'outerCylinder',
                  level = minlevel
                },
    geometry = { kind = 'stl',
                 object = { filename = 'outerCylinder.stl' }
               }
  },
  { -- Define periodic planes in Z direction
    attribute = { kind = 'periodic',
                  label = 'periodic',
                  level = minlevel
                },
    geometry = { kind = 'periodic',
                 object = { plane1 =
                              { origin = {-1.5, -1.5, -1.25},
                                vec = { {0.0, 3.0, 0.0}, {3.0, 0.0, 0.0} }
                              },
                            plane2 =
                              { origin = {-1.5, -1.5, 1.25},
                                vec = { {3.0, 0.0, 0.0}, {0.0, 3.0, 0.0} }
                              }
                          }
               }
  },
  { -- Defining a seed to identify the part of the computational domain in
    -- the universe cube.
    attribute = { kind = 'seed' },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = { origin = {0.25, 0.0, 0.0} }
               }
  }
}
