-- Use this file as template. Do not modify this file for running some testcases

outputname = 'connected_resonator'

-- The global refinement level of the mesh
largelevel = 3
minlevel = 5
bndlevel = 5
channellevel = 9

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                  origin = {-1.0, -1.0, -1.0},
                  length = 2.0
                }

eps = 1.0e-7
dxlarge = bounding_cube.length/math.pow(2,largelevel)
dxsmall = bounding_cube.length/math.pow(2,channellevel)

-- now we define the geometrical objects in our domain.
spatial_object = {
              -- eastern pec bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecEast',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {0.0,2.0*dxlarge+2*eps,0.0},
                                              {0.0,0.0,2.0*dxlarge+2*eps},
                                            },
                                       origin={3.0*dxlarge+eps,-dxlarge-eps,-dxlarge-eps},
                                      },
                          }
              },
              -- western pec bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecWest',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {0.0,2.0*dxlarge+2*eps,0.0},
                                              {0.0,0.0,2.0*dxlarge+2*eps},
                                            },
                                       origin={-3.0*dxlarge-eps,-dxlarge-eps,-dxlarge-eps},
                                      },
                          }
              },
              -- northern pec bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecNorth',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {6.0*dxlarge+2*eps,0.0,0.0},
                                              {0.0,0.0,2.0*dxlarge+2*eps},
                                            },
                                       origin={-3.0*dxlarge-eps,dxlarge+eps,-dxlarge-eps},
                                      },
                          }
              },
              -- southern pec bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecSouth',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {6.0*dxlarge+2*eps,0.0,0.0},
                                              {0.0,0.0,2.0*dxlarge+2*eps},
                                            },
                                       origin={-3.0*dxlarge-eps,-dxlarge-eps,-dxlarge-eps},
                                      },
                          }
              },
              -- top and bottom are periodic
              {
               attribute = {
                             kind = 'periodic',
                             label = 'periodic',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'periodic',
                             object = {
                                        -- top plane
                                        plane1 = 
                                                 {
                                                  vec= {
                                                         {6.0*dxlarge+2*eps,0.0,0.0},
                                                         {0.0,2.0*dxlarge+2*eps,0.0},
                                                       },
                                                  origin={-3.0*dxlarge-eps,-dxlarge-eps,dxlarge+eps},
                                                 },
                                        -- bottom plane
                                        plane2 = 
                                                 {
                                                  vec= {
                                                         {6.0*dxlarge+2*eps,0.0,0.0},
                                                         {0.0,2.0*dxlarge+2*eps,0.0},
                                                       },
                                                  origin={-3.0*dxlarge-eps,-dxlarge-eps,-dxlarge-eps},
                                                 },
                                      },
                          }
              },
              -- north channel bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecChannelNorth',
                             level = channellevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {2.0*dxlarge-2*eps,0.0,0.0},
                                              {0.0,0.0,2.0*dxsmall+2*eps},
                                              --{0.0,0.0,2.0*dxlarge+2*eps},
                                              --{0.0,dxlarge,0.0},
                                            },
                                       origin={-dxlarge+eps,dxsmall+eps,-dxsmall-eps},
                                       --origin={-dxlarge+eps,dxsmall+eps,-dxlarge-eps},
                                      },
                          }
              },
              -- south channel bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecChannelSouth',
                             level = channellevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {2.0*dxlarge-2*eps,0.0,0.0},
                                              {0.0,0.0,2.0*dxsmall+2*eps},
                                              --{0.0,0.0,2.0*dxlarge+2*eps},
                                              --{0.0,-dxlarge,0.0},
                                            },
                                       origin={-dxlarge+eps,-dxsmall-eps,-dxsmall-eps},
                                       --origin={-dxlarge+eps,-dxsmall-eps,-dxlarge-eps},
                                      },
                          }
              },
              -- top channel bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecChannelTop',
                             level = channellevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {2.0*dxlarge-2*eps,0.0,0.0},
                                              {0.0,2.0*dxsmall+2*eps},
                                              --{0.0,2.0*dxlarge+2*eps},
                                              --{0.0,0.0,dxlarge},
                                            },
                                       origin={-dxlarge+eps,-dxsmall-eps,dxsmall+eps},
                                       --origin={-dxlarge+eps,-dxlarge-eps,dxsmall+eps},
                                      },
                          }
              },
              -- bottom channel bnd
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecChannelBottom',
                             level = channellevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {2.0*dxlarge-2*eps,0.0,0.0},
                                              {0.0,2.0*dxsmall+2*eps},
                                              --{0.0,2.0*dxlarge+2*eps},
                                              --{0.0,0.0,-dxlarge},
                                            },
                                       origin={-dxlarge+eps,-dxsmall-eps,-dxsmall-eps},
                                       --origin={-dxlarge+eps,-dxlarge-eps,-dxsmall-eps},
                                      },
                          }
              },
              -- north channel bnd with coarse level
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecChannelNorthCoarse',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {2.0*dxlarge-2*eps,0.0,0.0},
                                              {0.0,0.0,2.0*dxlarge+2*eps},
                                              {0.0,dxlarge,0.0},
                                            },
                                       origin={-dxlarge+eps,dxsmall+eps,-dxlarge-eps},
                                      },
                          }
              },
              -- south channel bnd with coarse level
              {
               attribute = {
                             kind = 'boundary',
                             label = 'pecChannelSouthCoarse',
                             level = bndlevel,
                           },
               geometry = {
                             kind = 'canoND',
                             object = 
                                      {
                                       vec= {
                                              {2.0*dxlarge-2*eps,0.0,0.0},
                                              {0.0,0.0,2.0*dxlarge+2*eps},
                                              {0.0,-dxlarge,0.0},
                                            },
                                       origin={-dxlarge+eps,-dxsmall-eps,-dxlarge-eps},
                                      },
                          }
              },
           
              -- seed 
              {
              attribute = {
                           kind = 'seed'
                          },
              geometry = {
                           kind = 'canoND',
                           object =  
                                    {
                                       origin = {0.0, 0.0,0.0 },
                                    },
                         },
              },
        }

