-- Use this file as template. Do not modify this file for running some testcases

outputname = 'harmonic_dipole'
outputpreview = true 

-- The global refinement level of the mesh
level = 8

-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory
stl_files = { 
             {'input/outerCylinder.stl', 'outerCylinder', 'binary'},  
            }

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
boundingbox = {
               origin = {-1.5, -1.5, -1.5},
               length = 3.0
              }
geom = {
         periodic = 
                {
                 {
                   plane1={
                         vecA={3.0, 0.0, 0.0},
                         vecB={0.0, 3.0, 0.0},
                         pos={-1.5, -1.5,-0.10}},
                   plane2={
                         vecA={3.0,0.0,0.0},
                         vecB={0.0,3.0,0.0},
                         pos={-1.5,-1.5,0.10}},
                   bclabel = 'periodicZ',
                   refinementlevel = level
                 }
                }
        }

-- A refinement box for the vertex based visualization in the harvester
--refinebox = {
--            {
--              origin = {-1.25, -1.25, -1.25},
--              length = {2.5,2.5,2.5},
--              refinementlevel = level,
--              deformable = true
--            } 
--            }

-- seed: position of seed 
seed = {0.00,
        0.00,
        0.00,
       }

-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- (deprecated - used only for spacer stuff right now)
-- will become default for stl refinement level once
-- it is not mandatory any more
minrefine = level
maxrefine = level

