require('seeder')

name = 'inhom_maxwell_modg'

--logging = { level = 20 }
 
-- define the input
input = {
         read = './restart/simulation_lastHeader.lua',

         -- define the subsampling parameters
         subsampling = {
                         levels = 8, 
                         projection = 'QLegendrePoint',
                       }
  }


-- define the output
output = {  -- some general information
            folder = './tracking/',     -- Output location 

           {

    
            format = 'VTU',   -- Output format 

            binary = true,
            vrtx = {           -- when this table is defined set use_vrtx = .true.
                   } 
           }    ,
           {
               format = 'ASCII', 
               label = '_trackLine',
               vrtx ={},
               shape = {
                         kind = 'canoND',
                         object = {
                                     origin = { -cubeLength/2,elemsize/2,1e-6 },
                                     vec ={
                                            {cubeLength,0,0},
                                          },
                                     segments = 2^(minlevel+input.subsampling.levels),
                                  },
                       }
           }    

         }

