require('seeder')
require('post_params')
require('sim_params')

name = 'mie_scatter'

-- define the input
input = {
         read = os.getenv('RESTART_FOLDER') .. '/mie_scatter_lastHeader.lua',
         
         -- define the subsampling parameters
         subsampling = {
                         levels = post_level, 
                         projection = 'QLegendrePoint',
                       },
         add_variable = {
                            {
                                name = 'ref_miescatter_displacementfieldz',
                                ncomponents = 1,
                                ref_miescatter_displacementfieldz = {
                                                                   kind = 'miescatter_displacementfieldz',
                                                                   center = { x_circle_center, y_circle_center },
                                                                   radius = radius,
                                                                   permeaPermit_background = {cube_permea_back, cube_permit_back},
                                                                   permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
                                                                   frequency = frequency,
                                                                   nCoeffs = nCoeffs,
                                                                },
                            }, 
                            {
                                name = 'ref_miescatter_magneticfieldx',
                                ncomponents = 1,
                                ref_miescatter_magneticfieldx = {
                                                                   kind = 'miescatter_magneticfieldx',
                                                                   center = { x_circle_center, y_circle_center },
                                                                   radius = radius,
                                                                   permeaPermit_background = {cube_permea_back, cube_permit_back},
                                                                   permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
                                                                   frequency = frequency,
                                                                   nCoeffs = nCoeffs,
                                                                },
                            }, 
                            {
                                name = 'ref_miescatter_magneticfieldy',
                                ncomponents = 1,
                                ref_miescatter_magneticfieldy = {
                                                                   kind = 'miescatter_magneticfieldy',
                                                                   center = { x_circle_center, y_circle_center },
                                                                   radius = radius,
                                                                   permeaPermit_background = {cube_permea_back, cube_permit_back},
                                                                   permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
                                                                   frequency = frequency,
                                                                   nCoeffs = nCoeffs,
                                                                },
                            }, 
                        },
  }


-- define the output
output = { 
           folder = os.getenv('HARVEST_FOLDER') .. '/',     -- Output location 

           {
               format = 'VTU',   

               binary = true,
               vrtx = {          
                      },
               requestedData = {
                                variable = {
                                             {'displacementField'},
                                             {'magneticField'},
                                             {'ref_miescatter_displacementfieldz'},
                                             {'ref_miescatter_magneticfieldx'},
                                             {'ref_miescatter_magneticfieldy'},
                                             { name = 'difference', ncomponents = 1, dep = {'displacementField_Z','ref_miescatter_displacementfieldz'}},
                                             --{ name = 'difference', ncomponents = 1, dep = {'magneticField_X','ref_miescatter_magneticfieldx'}},
                                             --{ name = 'difference', ncomponents = 1, dep = {'magneticField_Y','ref_miescatter_magneticfieldy'}},
                                           },
                               },
               shape = {
                         kind = 'canoND',
                         object = {
                                     origin = { -cubeLength/2,-cubeLength/2,0 },
                                     vec ={
                                            {cubeLength,0,0},
                                            {0,cubeLength,0},
                                          },
                                     segments = {2*cubeLength/post_elemsize,2*cubeLength/post_elemsize},
                                  },
                       }
           }, 
           {

                label = '_track',
                format = 'ASCII',   -- Output format 

                vrtx = {
                       },
                requestedData = {
                                variable = {
                                             {'displacementField'},
                                             {'magneticField'},
                                             {'ref_miescatter_displacementfieldz'},
                                             {'ref_miescatter_magneticfieldx'},
                                             {'ref_miescatter_magneticfieldy'},
                                             { name = 'difference', ncomponents = 1, dep = {'displacementField_Z','ref_miescatter_displacementfieldz'}},
                                             --{ name = 'difference', ncomponents = 1, dep = {'magneticField_X','ref_miescatter_magneticfieldx'}},
                                             --{ name = 'difference', ncomponents = 1, dep = {'magneticField_Y','ref_miescatter_magneticfieldy'}},
                                           },
                               },
                shape = {
                          kind = 'canoND',
                          object = {
                                      origin = { -cubeLength/2,post_elemsize/2,0 },
                                      vec ={
                                             {cubeLength,0,0},
                                           },
                                      segments = 2*cubeLength/post_elemsize,
                                   },
                        }
           }

}

