-- The level of the mesh for the simulation
mesh_level = os.getenv('MESHLEVEL')

-- The bounding box length
cubeLength = 4.0

-- The simulation domain
bounding_cube = {
    origin = {
        cubeLength/(-2.0),
        cubeLength/(-2.0),
        cubeLength/(-2.0)
    },
    length = cubeLength
}

outputname = 'mieScatter'
folder = os.getenv('MESH_FOLDER')

minlevel = mesh_level

-- smallness parameter
eps = bounding_cube.length/(2^(minlevel+5))

-- the size of an element
elemsize = bounding_cube.length/(2^(minlevel))

-- -----------------------------------
spatial_object = {
--
    { -- periodic boundary in z direction
        attribute = {
            kind  = 'periodic',
            level = minlevel
        },
        geometry = {
            kind = 'periodic',
            object = {
                plane1 = {
                    vec = {
                        {       0.0, cubeLength, 0.0},
                        {cubeLength,        0.0, 0.0}
                    },
                    origin = {
                        -cubeLength/2 + eps,
                        -cubeLength/2 + eps,
                        -eps
                    }
                },
                plane2 = {
                    vec = {
                        {cubeLength, 0.0,        0.0},
                        {       0.0, cubeLength, 0.0}
                    },
                    origin = {
                             -bounding_cube.length/2 + eps,
                             -bounding_cube.length/2 + eps,
                             elemsize + eps
                    }
                }
            }
        }
    },
    -- ----------------------------------------

    { -- seed
        attribute = { kind = 'seed' },
        geometry = {
            kind = 'canoND',
            object =  { origin = {0,0,0} },
        }
    },
    -- ----------------------------------------

    { -- west boundary
        attribute = {
            kind  = 'boundary',
            label = 'west',
            level = minlevel
        },
        geometry = {
            kind = 'canoND',
            object = {
                vec = {
                    {0.0, cubeLength,        0.0},
                    {0.0,        0.0, cubeLength}
                },
                origin = {
                   -(cubeLength/4.0)-eps,
                   -cubeLength/2.0,
                   -cubeLength/2.0
                }
            }
        }
    },
    -- ----------------------------------------

    { -- east boundary
        attribute = {
            kind = 'boundary',
            label = 'east',
            level = minlevel
        },
        geometry = {
            kind = 'canoND',
            object = {
                vec = {
                    {0.0, cubeLength,        0.0},
                    {0.0,        0.0, cubeLength}
                },
                origin = {
                    (cubeLength/4.0)+eps,
                    -cubeLength/2.0,
                    -cubeLength/2.0
                }
            }
        }
    },
    -- ----------------------------------------

    { -- north boundary
        attribute = {
            kind = 'boundary',
            label = 'north',
            level = minlevel
        },
        geometry = {
            kind = 'canoND',
            object = {
                vec = {
                    {cubeLength, 0.0,        0.0},
                    {       0.0, 0.0, cubeLength}
                },
                origin = {
                    -cubeLength/2.0,
                    -(cubeLength/4.0)-eps,
                    -cubeLength/2.0
                }
            }
        }
    },
    -- ----------------------------------------

    { --south boundary
        attribute = {
            kind = 'boundary',
            label = 'south',
            level = minlevel
        },
        geometry = {
            kind = 'canoND',
            object = {
                vec = {
                    {cubeLength, 0.0,        0.0},
                    {       0.0, 0.0, cubeLength}
                },
                origin = {
                    -cubeLength/2.0,
                    (cubeLength/4.0)+eps,
                    -cubeLength/2.0
                }
            }
        }
    }
    -- ----------------------------------------

}
