require('seeder')
require('post_params')

-- Temporal frequency of the excitational wave
frequency = 10
period = 1.0/frequency

-- Equation definitions --
-- ... material parameters inside te circle
cube_permea_circ = 2.0
cube_permit_circ = 2.0

-- ... material parameters of the background material
cube_permea_back = 1.0
cube_permit_back = 1.0

-- ... the center of the circle
x_circle_center = post_elemsize/2.0
y_circle_center = x_circle_center
circle_center = {x_circle_center, y_circle_center}

radius = 0.21

function permeability_permitivity(x,y,z,t)
  -- Calculate the distance from the circle center
  dist = math.sqrt( (x-x_circle_center)^2
                   + (y-y_circle_center)^2 )
  -- Check if the point is inside the circle
  if dist <= radius  then
    return { cube_permea_circ, cube_permit_circ, 0.0 }
  else
    return { cube_permea_back, cube_permit_back, 0.0 }
  end
end

-- ------------------------------------
equation = {
--
    name   = 'maxwell',
--
    material = {
        -- Circle
        {
             kind = 'lua_fun',
             fun = permeability_permitivity,
             shape = {
                 kind = 'canoND',
                 object = {
                     origin = {
                         x_circle_center - radius,
                         y_circle_center - radius,
                         0.0
                     },
                     vec = {
                         {2.0*radius,        0.0,      0.0},
                         {       0.0, 2.0*radius,      0.0},
                         {       0.0,        0.0, elemsize},
                     },
                     segments = {100, 100, 10},
                 }
             }
        },
        -- The background permitivity and permeability
        global = {
            kind = 'const',
            const = {cube_permea_back, cube_permit_back, 0.0}
        }
    }
}
-- ------------------------------------


-- Check for Nans and unphysical values
check =  { interval = 1 }

nCoeffs = 50

mieMagFieldX = {
    kind = 'miescatter_magneticfieldx',
    predefined = 'miescatter_magneticfieldx',
    center = circle_center,
    radius = radius,
    permeaPermit_background = {cube_permea_back, cube_permit_back},
    permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
    frequency = frequency,
    nCoeffs = nCoeffs
}

mieMagFieldY = {
    kind = 'miescatter_magneticfieldy',
    predefined = 'miescatter_magneticfieldy',
    center = circle_center,
    radius = radius,
    permeaPermit_background = {cube_permea_back, cube_permit_back},
    permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
    frequency = frequency,
    nCoeffs = nCoeffs
}

mieDispFieldZ = {
    kind = 'miescatter_displacementfieldz',
    predefined = 'miescatter_displacementfieldz',
    center = circle_center,
    radius = radius,
    permeaPermit_background = {cube_permea_back, cube_permit_back},
    permeaPermit_cylinder = {cube_permea_circ, cube_permit_circ},
    frequency = frequency,
    nCoeffs = nCoeffs
}

-- ------------------------------------
initial_condition = {
--
    displacement_fieldX = 0.0,
    displacement_fieldY = 0.0,
    displacement_fieldZ = mieDispFieldZ,
    magnetic_fieldX     = mieMagFieldX,
    magnetic_fieldY     = mieMagFieldY,
    magnetic_fieldZ     = 0.0,
    useFpt = true
}
-- ------------------------------------


-- ------------------------------------
boundary_condition = {}
--
for k,side in pairs({'east', 'west', 'south', 'north'}) do
  table.insert( boundary_condition,
      { label = side,
        kind = 'conservatives',
        displacement_fieldX = 0.0,
        displacement_fieldY = 0.0,
        displacement_fieldZ = mieDispFieldZ,
        magnetic_fieldX     = mieMagFieldX,
        magnetic_fieldY     = mieMagFieldY,
        magnetic_fieldZ     = 0.0 }
  )
end
-- ------------------------------------
