import vtk
import math
import sys
# This script reads a harvester output file (VTK) and calculates the L2-norm of
# (Harvester output - analytical solution)
# This only works if the initial condition is set according to 'electric' and 'magnetic' (below)
#
# call this script with
# python harvestError.py <input-filename>
# to get the result printed out to the terminal

def electric(x,y,z):
  x = x-0.25
  y = y-0.25
  z = z-0.25
  t=0.001
  amplX = 1.0
  amplY = 1.0
  w = math.sqrt(2)*math.pi
  return [0.0, 0.0, math.sin(math.pi*x)*math.sin(math.pi*y)*math.cos(w*t)]

def magnetic(x,y,z):
  x = x-0.25
  y = y-0.25
  z = z-0.25
  t=0.001
  amplX = 1.0
  amplY = 1.0
  w = math.sqrt(2)*math.pi
  v = 1.0/math.sqrt(2)
  return [-v*math.sin(math.pi*x)*math.cos(math.pi*y)*math.sin(w*t), v*math.cos(math.pi*x)*math.sin(math.pi*y)*math.sin(w*t), 0.0]



reader = vtk.vtkDataSetReader()
#reader.SetFileName("harverr_t00000000.000E+00_vrtx_bin.vtk")
reader.SetFileName(sys.argv[1])
reader.ReadAllScalarsOn()
reader.ReadAllVectorsOn()
reader.Update()
data=reader.GetOutput()
d=data.GetCellData()

cellsperdim = round(math.pow(data.GetNumberOfCells(),1.0/3.0))
minbound = -1.0
maxbound = 1.0
domainsize = maxbound - minbound
cellsize = domainsize / cellsperdim
weights = [13.0/12.0, 11.0/12.0, 11.0/12.0, 13.0/12.0]

efielderr = [0,0,0]
mfielderr = [0,0,0]
for cellidx in range(data.GetNumberOfCells()-1L):
  cellbounds = data.GetCell(cellidx).GetBounds()
  centerx = (cellbounds[1]+cellbounds[0])/2
  centery = (cellbounds[2]+cellbounds[3])/2
  centerz = (cellbounds[4]+cellbounds[5])/2
  efield = d.GetArray('electricField').GetTuple3(cellidx)
  mfield = d.GetArray('magneticField').GetTuple3(cellidx)
  efield_ref = electric(centerx,centery,centerz)
  mfield_ref = magnetic(centerx,centery,centerz)
  idx = int((cellbounds[0]-minbound) / cellsize) % 4
  idy = int((cellbounds[2]-minbound) / cellsize) % 4
  idz = int((cellbounds[4]-minbound) / cellsize) % 4
  # fourth order quadrature
  thisweight = weights[idx]*weights[idy]*weights[idz]*8.0/data.GetNumberOfCells()
  #thisweight = 8.0/data.GetNumberOfCells()

  for dir in range(3):
    efielderr[dir] += thisweight*math.pow(abs(efield[dir]-efield_ref[dir]),2)
    mfielderr[dir] += thisweight*math.pow(abs(mfield[dir]-mfield_ref[dir]),2)

print math.sqrt(abs((sum(efielderr)+sum(mfielderr))))
