folder = 'mesh/'
comment = 'A fully periodic cube with a multi level jump'

--debug = { debugMode = true, debugFiles = true, debugMesh = './mesh/debug/' }

minlevel = 2

cubeLength = 2.0
bounding_cube = {
                  origin = { 
                           (-1.0)*cubeLength/2.0,
                           (-1.0)*cubeLength/2.0,
                           (-1.0)*cubeLength/2.0
                           },
                  length = cubeLength
                }



-- refinebox: three entries: origin, length and refinementlevel
elemLength = cubeLength/(2^minlevel)
eps = 1.0e-08
spatial_object = {
                   {
                     attribute = { 
                       kind = 'refinement', -- or seed, boundary
                       level = minlevel+2,
                     },

                     geometry = {
                       kind = 'canond',
                       object = {
                                  { 
                                    origin = { 
                                              (-1.0) * elemLength + eps,
                                              (-1.0) * elemLength + eps,
                                              (-1.0) * elemLength + eps,
                                             },
                                    length = 2.0*elemLength - 2.0*eps
                                  }
                                }
                     }
                   },
                   {
                      attribute = { kind = 'seed' },
                      geometry = { -- single point definition with a canoND object.
                                   kind = 'canoND',
                                   object = { origin = {0.0, 0.0, 0.0} }
                                 }
                   }
}

