-- Configuration file for Ateles --

-- The analytic solution of this testcase.
-- ... length of the waveguide
lengthX = 1.0
lengthY = 1.0
lengthZ = 3.0
-- ... shift of the coordinate system in x and y direction
xOffset = 0.5
yOffset = 0.5
-- ... the magnetic permeability
permea = 1
-- ... the displacement permitivity
permit = 1
-- .. speed of light
-- ... the physical mode indices
m = 1.0 -- x mode (this can be any integer)
n = (lengthY/lengthX)*m -- y mode (fixed by integer for m)
l = 2.0 -- z mode (only even integers are allowed for the analytic solution)
-- ... parameters for the analytic solution
gammaSq = 2.0 * (m*math.pi/lengthX)^2.0
w = math.sqrt( (gammaSq + (l*math.pi/lengthZ)^2.0) / (permea*permit) )
-- ... the temporal period of the waveguide
T = 2.0*math.pi/w

-- Definition of the analytical solution for all components of the Maxwell equation
-- ... displacement field - x component 
B = 1.0
function displacementX(x,y,z,t)
  return B * (n*math.pi/lengthY) * math.cos(m*math.pi*(x+xOffset)/lengthX) * math.sin(n*math.pi*(y+yOffset)/lengthY) * ((-1.0)*w/gammaSq) * math.sin(l*math.pi*z/lengthZ) * math.sin(w*t)
end
-- ... displacement field - y component 
function displacementY(x,y,z,t)
  return (-1.0) * B * (n*math.pi/lengthY) * math.sin(m*math.pi*(x+xOffset)/lengthX) * math.cos(n*math.pi*(y+yOffset)/lengthY) * ((-1.0)*w/gammaSq) * math.sin(l*math.pi*z/lengthZ) * math.sin(w*t)
end
-- ... displacement field - z component 
function displacementZ(x,y,z,t)
  return 0.0
end
-- ... magnetic field - x component
function magneticX(x,y,z,t)
  return (1.0/gammaSq) * (l*math.pi/lengthZ) * math.cos(l*math.pi*z/lengthZ) * (-1.0) * B * (n*math.pi/lengthY) * math.sin(m*math.pi*(x+xOffset)/lengthX) * math.cos(n*math.pi*(y+yOffset)/lengthY) * math.cos(w*t)
end 
-- ... magnetic field - y component
function magneticY(x,y,z,t)
  return (1.0/gammaSq) * (l*math.pi/lengthZ) * math.cos(l*math.pi*z/lengthZ) * (-1.0) * B * (n*math.pi/lengthY) * math.cos(m*math.pi*(x+xOffset)/lengthX) * math.sin(n*math.pi*(y+yOffset)/lengthY) * math.cos(w*t)
end 
-- ... magnetic field - z component
function magneticZ(x,y,z,t)
  return B * math.cos(m*math.pi*(x+xOffset)/lengthX) * math.cos(n*math.pi*(y+yOffset)/lengthY) * math.sin(l*math.pi*z/lengthZ) * math.cos(w*t)
end 

-- global simulation options
simulation_name = 'rectang_waveguide_maxwell_weno' -- the name of the simualtion
sim_control = {
                time_control = { 
                  max = 1.0*T -- final simulation time
                }
              }

--commpattern = 'gathered_type'

-- Mesh definitions --
mesh = './mesh/'

-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/',                                        
            -- temporal definition of restart write
            time_control = {   
              min = 0, 
              max = sim_control.time_control.max, 
              interval = sim_control.time_control.max/10.0
            }
          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }


-- Equation definitions --
equation = {
             name   = 'maxwell',                   -- we solve maxwell's equations
             material     = {                      -- The background permitivity and permeability
                                  global = {
                                             kind = 'const',
                                             const = {permea, permit, 0.0},
                                           },
                            },
            }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'weno',            -- we use the weno scheme for reconstruction
               m = 1,                     -- the reconstructed polynomial is of degree 1
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.3,     -- CourantFriedrichsLewy number
                         },
               },
}

-- ...initial condition function for displacement field 
function ic_displacementX(x,y,z)
  return displacementX(x,y,z,0)
end
function ic_displacementY(x,y,z)
  return displacementY(x,y,z,0)
end
function ic_displacementZ(x,y,z)
  return displacementZ(x,y,z,0)
end
-- ...initial condition function for magnetic field 
function ic_magneticX(x,y,z)
  return magneticX(x,y,z,0)
end
function ic_magneticY(x,y,z)
  return magneticY(x,y,z,0)
end
function ic_magneticZ(x,y,z)
  return magneticZ(x,y,z,0)
end
-- ...the initial condition table
initial_condition = { 
                      displacement_fieldX = ic_displacementX,  -- displacement field , x component
                      displacement_fieldY = ic_displacementY,  -- displacement field , y component
                      displacement_fieldZ = ic_displacementZ,  -- displacement field , z component
                      magnetic_fieldX = ic_magneticX,  -- magnetic induction , x component
                      magnetic_fieldY = ic_magneticY,  -- magnetic induction , y component
                      magnetic_fieldZ = ic_magneticZ,  -- magnetic induction , z component
                    }


-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'pecEast',   -- boundary for the inner cylinder
                       kind = 'pec',       
                       }
                       ,
                       { 
                       label = 'pecWest',   -- boundary for the outer cylinder
                       kind = 'pec',        
                       }
                       ,
                       { 
                       label = 'pecSouth',       -- boundary for the inner cylinder
                       kind = 'pec',        
                       }
                       ,
                       { 
                       label = 'pecNorth',       -- boundary for the inner cylinder
                       kind = 'pec',         
                       }
                     }  

