require('common')

-- Boundary conditions
boundary_condition = {
    {
         label = 'west',
         kind = 'inflow_normal',
         enforce_zero_grad = true,
         density = rho,
         v_norm = v
    },

    {
         label = 'east',
         kind = 'outflow',
         enforce_zero_grad = true,
         pressure = p
    }
}

restart = { 
    write = 'restart_smooth/',
    time_control = {
        min = 0,
        max = sim_control.time_control.max,
        interval = {iter=1}
    }
}
