import matplotlib.pylab as mplab
from matplotlib import pyplot as plt
from matplotlib import animation
import glob
import re
from operator import itemgetter

facefiles = glob.glob('harvest_face/*.res')
meanfiles = glob.glob('harvest_mean/*.res')
smoothfiles = glob.glob('harvest_smooth/*.res')

ftimes = []
for rf in facefiles:
  m = re.search('.*_t(?P<time>.*).res', rf)
  ftimes.append((float(m.group('time')), rf))

sortface = sorted(ftimes, key=itemgetter(0))

mtimes = []
for rf in meanfiles:
  m = re.search('.*_t(?P<time>.*).res', rf)
  mtimes.append((float(m.group('time')), rf))

sortmean = sorted(mtimes, key=itemgetter(0))

stimes = []
for rf in smoothfiles:
  m = re.search('.*_t(?P<time>.*).res', rf)
  stimes.append((float(m.group('time')), rf))

sortsmooth = sorted(stimes, key=itemgetter(0))

fig = plt.figure()
ax = plt.axes(xlim=(-1,1), ylim=(1.39999999999,1.40000000001))
ax.set_xticks([-1, -2./6., 2./6., 1])
ax.xaxis.grid(True)
line_face, = ax.plot([], [], lw=1, label = 'Face')
line_mean, = ax.plot([], [], lw=1, label = 'Mean')
line_smooth, = ax.plot([], [], lw=1, label = 'Smoothed')
ax.legend(loc = 3, bbox_to_anchor = (0.33, 1.02, 0.66, 0.125),
             ncol = 3, mode='expand', borderaxespad=0.)

def animate(i):
  state_face = mplab.loadtxt(sortface[i][1])
  line_face.set_data(state_face[:,0], state_face[:,5])

  state_mean = mplab.loadtxt(sortmean[i][1])
  line_mean.set_data(state_mean[:,0], state_mean[:,5])

  state_smooth = mplab.loadtxt(sortsmooth[i][1])
  line_smooth.set_data(state_smooth[:,0], state_smooth[:,5])
  return line_face, line_mean, line_smooth

anim = animation.FuncAnimation(fig, animate, frames=len(sortface), interval=40)
anim.save('pressure_const.mp4', fps=25, bitrate=2000)
plt.show()
