-- Configuration file for Ateles --


-- ...the length of the cube
cubeLength = 2.0


-- global simulation options
simulation = {
              name          = 'channel_euler_modg',             -- the name of the simualtion
              time          = {
                                useIterations = false,
                                min = 0.0,
                                max = 1.0e-03,                  -- final simulation time
                              },
             }


-- Mesh definitions --
mesh = './mesh/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/',                                        
            -- temporal definition of restart write
            time = {   
                      useIterations = false,  
                      min = 0, 
                      max = simulation.time.max, 
                      interval = simulation.time.max/200.0,
                   },  
          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  7,                   -- the maximal polynomial degree for each spatial direction
               dealiasFactor = 1.0,      -- factor to remove aliases: 1.0 means no additional dealiasing
               blocksize = 32,
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  --'explicitEuler',
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.6,       -- CourantFriedrichsLewy number
                         },
               },
}

function velX(x,y,z,t)
  return ( (-1.0)*(y^2+z^2) + 0.25^2 + 0.25^2 ) * ( math.tanh((-1.0)*x) + 1.0)
end 

function velXIni(x,y,z)
  return velX(x,y,z,0.0)
end 

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = 1.225,
                      pressure = 100000,
                      velocityX = velXIni,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                      projOverSampling =  1,
                    }

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }


-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'inflowEast',  
                       kind = 'inflow_normal',      
                       density = 1.225,
                       v_norm = velX,
                       v_tan = 0.0,
                       }
                       ,
                       { 
                       label = 'outflowWest',  
                       kind = 'outflow',       
                       pressure = 100000,
                       }
                       ,
                       { 
                       label = 'slipSouth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipNorth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       }
                       ,
                     }  
