-- Configuration file for Ateles --
sim_name = 'ns_const_state'
sim_control = {
                time_control = { max = {iter=20000}, -- final Simulated time
                                 min = 0.0,
                                 interval = { iter = 1000 },
                               }
             }
logging = { level = 8 }

-- Check for Nans and unphysical values
check =  { interval = 1 }

-- the order of the scheme:
degree = 2 

-- Restart settings
io_buffer_size = 20

-- ...the initial condition table. 
isen = 1.4
boltz= 287.0
rho  = 1.4
p    = 1.0
mach = 0.1
-- ... define background velocity (ATTENTION: change boundaries accordingly)
vel  = mach * math.sqrt(isen * p / rho ) --TODO 0.6 --TODO 1.1
-- ... define the temperature in the penalization area
temp = p / ( rho * boltz )


variable = {
  -- This is the global material for Euler 2D. It consists of three different 
  -- components, characteristics with one scalar, relax_velocity with two 
  -- scalars and relax_temperature with one scalar, thus we need four scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a 
  -- neutral term, which in this case is 0.
  {
    name = "characteristic",
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = { const = 0.0 }
  },
  {
    name = "relax_velocity",
    ncomponents = 2,
    vartype = "st_fun",
    st_fun = {
      const = { 0.0, 0.0 }
    }
  },
  {
    name = "relax_temperature",
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = { const = 0.0 }
  }
}

--cylinder_radius = 1.5*dx
cube_length = 2.0
mesh = {
        predefined = 'line',      -- use the predefined full cube
        origin = {                -- origin of the cube
                   (-1.0)*cube_length/2.0,
                   (-1.0)*cube_length/2.0,
                   (-1.0)*cube_length/2.0
                 },
        length = cube_length,     -- length of the cube
        element_count = 1
       }

-- Scheme definitions --
scheme = {
    spatial =  {
                  name = 'modg_2d',          
                  m = degree,                 
               },
    temporal = {
                  name = 'explicitEuler',
                  control = {
                             name     = 'cfl', 
                             cfl      = 0.1,
                             cfl_visc = 0.4,
                            },
               },
}


-- ...the general projection table
projection = {
              kind = 'fpt', --fpt
              -- lobattoPoints = true,
              factor = 2.0,
             }

-- Equation definitions 
equation = {
  name   = 'navier_stokes_2d',                 
  isen_coef            = isen,
  r                    = boltz,
  -- Viscous parameters
  therm_cond = 0.5,
  mu         = 2.0,
  ip_param   = 4.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

 
initial_condition = { 
                      density  = rho,
                      pressure = p,
                      velocityX = vel,
                      velocityY = 0.0,
                    }

-- Tracking              
tracking = {
             label = 'track_const_state_l2p',
             folder = './',
             variable = {'momentum','density','energy'},
             shape = {kind = 'canoND', object= { origin ={0., 0., 0.} } },
             time_control = {
               min = 0,
               max = sim_control.time_control.max,
               interval = {iter = 1000}
             },
             output = { format = 'ascii', ndofs = 1 }
           }
