-- Configuration file for Ateles --
require 'seeder_2d'


name = 'plate_modg'

-- global simulation options
sim_control = {
              time_control  = {
                                min = 0.0,
                                max = 6.0,
                                interval = {iter=100},       
                              },
             }


-- Mesh definitions --
mesh = './mesh/'

check = {
          interval = 1,
        }

-- Restart settings
restart = { 
            write = './restart/',                                        
            time_control = {   
                             min = 0, 
                             max = sim_control.time_control.max, 
                             interval = sim_control.time_control.max/30,
                          },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg_2d', 
               m = 15,
               --TODO m = {
               --TODO       { level =  6, m = 8 },    
               --TODO       { level =  7, m = 8 },    
               --TODO       { level =  8, m = 5 },    
               --TODO       { level =  9, m = 4 },  
               --TODO       { level = 10, m = 2 },  
               --TODO       { level = 11, m = 2 },  
               --TODO     }, 
               dealiasFactor = 1.0, 
               blocksize = 32,
               }, 
    -- the stabilzation of the scheme
    stabilization = {
                       {
                         name = 'spectral_viscosity',
                         alpha = 36,
                         order = 8,
                       },
                      --TODO {
                      --TODO    name = 'cons_positivity_preserv',
                      --TODO    eps = 1e-6,
                      --TODO },
                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  
               steps = 4,
               -- how to control the timestep
               control = {
                          name      = 'cfl',   -- the name of the timestep control mechanism
                          cfl       = 0.4,     -- Courant Friedrichs Lewy number
                          cfl_visc  = 0.4,     -- Courant Friedrichs Lewy number
                         },
               },
}

-- parameters for initial conditions, sponge layer and boundary conditions
iniVel = 2*0.5 --TODO 0.10 
iniDens = 2.0
iniPress = 1.0 


-- Sponge definition
sponge_fraction_out = 0.125 -- the part of the channel used for the sponge zone (outlet)
sponge_fraction_in  = 0.125 -- the part of the channel used for the sponge zone (inlet)
print('End of inlet sponge: ',-bounding_cube.length/2+bounding_cube.length*sponge_fraction_in +eps)
source = {
  spongeLayer = {
    shape = {   
      kind = 'canoND', 
      object= {
        origin = {
          bounding_cube.length/2-bounding_cube.length*sponge_fraction_out + eps,
          0.0,
          0.0,
        },
        length = bounding_cube.length*sponge_fraction_out,
        segments = {100,100,100}
      }
    },
    kind = 'combined',
    spatial = { 
      predefined = 'spongeLayer_2d', 
      plane_origin = {bounding_cube.length/2-bounding_cube.length*sponge_fraction_out,0.0,0},
      plane_normal = {1.0,0,0},
      damp_factor = 100,--TODO 10
--      damp_exponent = {},
      target_state = {
        density = iniDens,
        velx = iniVel,
        vely = 0.0,
        pressure= iniPress
      }, 
    },
  },
  spongeLayer = {
    shape = {   
      kind = 'canoND', 
      object= {
        origin = {
          -bounding_cube.length/2+bounding_cube.length*sponge_fraction_in -eps,
          0.0,
          0.0
        },
        vec = {
          {-bounding_cube.length*sponge_fraction_in,0.0,0.0},
          {0.0,bounding_cube.length*sponge_fraction_in,0.0},
          {0.0,0.0,bounding_cube.length*sponge_fraction_in}
        },
        segments = {100,100,100}
      }
    },
    kind = 'combined',
    spatial = { 
      predefined = 'spongeLayer_2d', 
      plane_origin = {-bounding_cube.length/2+bounding_cube.length*sponge_fraction_in,0.0,0},
      plane_normal = {-1.0,0,0},
      damp_factor = 100,--TODO 10
--      damp_exponent = {},
      target_state = {
        density = iniDens,
        velx = iniVel,
        vely = 0.0,
        pressure= iniPress
      }
    }
  }
}

function velX(x,y,z,t)
  return iniVel
end 

function velXIni(x,y,z)
  return velX(x,y,z,0.0)
end 

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = iniDens,
                      pressure = iniPress,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                      projOverSampling = 1,
                    }

-- ...the general projection table
projection = {
              kind = 'fpt',          
              lobattoPoints = true,
              factor = 1.0,          
              blocksize = 32,        
           -- fftmultithread = false 
             }


-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'inflowEast',  
                       kind = 'supersonic_inflow_normal',      
                       density = iniDens,
                       v_norm = velX,
                       v_tan = 0.0,
                       pressure = iniPress,
                       }
                       ,
                       { 
                       label = 'outflowWest',  
                       kind = 'supersonic_outflow',       
                       --TODO kind = 'outflow',       
                       pressure = iniPress,
                       }
                       ,
                       { 
                       label = 'slipSouth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipNorth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'plate', 
                       kind = 'wall',       
                       }
                       ,
                     }  
