folder = 'mesh/'
comment = 'A fully periodic cube with a multi level jump in the center'

--debug = { debugMode = true, debugFiles = true, debugMesh = './mesh/debug/' }

minlevel = 2

bounding_cube = { origin = { -1, -1, -1 }, length = 2 }

-- refinebox: three entries: origin, length and refinementlevel
eps = 1.0e-08
spatial_object = {
  {
    attribute = { 
      kind = 'refinement',
      level = minlevel+1,
    },

    geometry = {
      kind = 'canoND',
      object = {
        { origin = { eps-0.5, eps-0.5, eps-0.5 },
          length = 1-2*eps }
      }
    }
  },
  {
    attribute = { kind = 'seed' },
    geometry = {
      kind = 'canoND',
      object = { origin = {0.0, 0.0, 0.0} }
    }
  }
}
