-- Use the configuration of the original simulation run.
require 'ateles'
-- Logging level, required to be > 3 since harvester takes the written
-- time to generate the output name and create the pvd file
logging = {level=3}

-- Set the restart data to harvest.
restart = {
  read = 'restart_convected_vortex_lastHeader.lua'
}


-- Subsampling for tracking, define a ply_sampling table to activate subsampling
-- for all tracking objects (except those with use_get_point).
-- Subsampling (for subresolved color information):
ply_sampling = {
  nlevels = 4,    -- maximal level to use in subsampling
                  -- defaults to 0, which deactivates subsampling
  method = 'adaptive',
  tolerance = 0.0005,
  adaptiveDofReduction = true
}

-- Example tracking to generate vtk files:
tracking = {
  { label = 'visu',
    variable = {'density','mach_number'},
    shape = {kind='global'},
    folder = 'harvest_',
    -- output format
    -- write_pvd=false important to create complete pvd file by harvester
    -- and not single pvd files by the solver
    output = {format = 'vtk', write_pvd=false}
  }
}
