require('common_3d')

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = therm_cond,
    isen_coef  = isen_coef,
    r          = r,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

filter_order = 14
scheme.stabilization[1] = {
                          name = 'spectral_viscosity',
                          alpha = 36,
                          order = filter_order,
                         }
scheme.stabilization[2] = {
                           name = 'covolume',
                           alpha = 36,
                           order = filter_order,
                           beta = 1, --TODO 1.0 - 2.0/(scheme.spatial.m+1),
                          }

scheme.temporal = {
                     name = 'explicitRungeKutta', 
                     steps = 4,
                     control = {
                                name = 'cfl', 
                                cfl  = 0.6*3*3,  
                               },
                  }

