-- Use this file as template. Do not modify this file for running some testcases
folder = 'mesh_3d/'

outputname = 'jet'
outputpreview = true 

-- ATTENTION: the minimum is 3, otherwise you won't get any fluid element.
minlevel = 6

-- the finest level
finestlevel = 12
--finestlevel = minlevel+8

cubeLength = 256.0

-- the largest element
elemsize = cubeLength/(2^minlevel)
--elemsizeSmall = cubeLength/(2^finestlevel)

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {-elemsize,cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

-- smallness parameter
eps = bounding_cube.length/(2^(finestlevel+3))

-- the diameter of the jet
jet_radius = 0.1
jet_center_y = 1e-4
jet_center_z = 3.1e-4

spatial_object = {
  -- the refinement boxes at the bottom of the domain
--  {
--    attribute = {
--       kind = 'refinement',
--       level = minlevel+1,
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        vec= {
--          {0.80*cubeLength/2,0.0,0.0},
--          {0.0,640*jet_radius,0.0},
--          {0.0,0.0,640*jet_radius},
--        },
--        origin={
--          eps,
--          -320*jet_radius,
--          -320*jet_radius
--        },
--      },
--    }
--  },
--  {
--    attribute = {
--      kind = 'refinement',
--      level = minlevel+2,
--    },
--    geometry = {
--      kind = 'canoND',
--      object ={
--        vec= {
--               {0.80*cubeLength/2/2,0.0,0.0},
--               {0.0,360*jet_radius,0.0},
--               {0.0,0.0,360*jet_radius},
--        },
--        origin={
--                 eps,
--                 -180*jet_radius,
--                 -180*jet_radius
--        },
--      },
--    }
--  },
  {
    attribute = {
      kind = 'refinement',
      level = minlevel+1,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {0.95*cubeLength/2/2/2,0.0,0.0},
          {0.0,168*jet_radius,0.0},
          {0.0,0.0,168*jet_radius},
        },
        origin={
          eps,
          -84*jet_radius,
          -84*jet_radius
        },
      },
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = minlevel+2,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
               {0.70*cubeLength/2/2/2,0.0,0.0},
               {0.0,128*jet_radius,0.0},
               {0.0,0.0,128*jet_radius},
        },
        origin={
          eps,
          -64*jet_radius,
          -64*jet_radius
        },
      },
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = minlevel+3,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
               {0.55*cubeLength/2/2/2,0.0,0.0},
               {0.0,96*jet_radius,0.0},
               {0.0,0.0,96*jet_radius},
        },
        origin={
          eps,
          -48*jet_radius,
          -48*jet_radius
        },
      },
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = minlevel+4,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
               {0.40*cubeLength/2/2/2,0.0,0.0},
               {0.0,48*jet_radius,0.0},
               {0.0,0.0,48*jet_radius},
             },
        origin={
          eps,
          -24*jet_radius,
          -24*jet_radius
        },
      },
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = minlevel+5,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {0.30*cubeLength/2/2/2,0.0,0.0},
          {0.0,24*jet_radius,0.0},
          {0.0,0.0,24*jet_radius},
        },
        origin={
          eps,
          -12*jet_radius,
          -12*jet_radius
        },
      },
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = minlevel+6,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {0.20*cubeLength/2/2/2,0.0,0.0},
          {0.0,12*jet_radius,0.0},
          {0.0,0.0,12*jet_radius},
        },
        origin={
          eps,
          -6*jet_radius,
          -6*jet_radius
        },
      },
    }
  },
  -- now the boundaries
  -- west inflow bnd
  {
    attribute = {
      kind = 'boundary',
      label = 'inflowWest',
      level = minlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {0.0,bounding_cube.length,0.0},
          {0.0,0.0,bounding_cube.length},
        },
        origin={
          -eps,
          -bounding_cube.length/2+eps,
          -bounding_cube.length/2+eps
        },
      },
    }
  },
  -- east outflow bnd
  {
    attribute = {
      kind = 'boundary',
      label = 'outflowEast',
      level = minlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {0.0,bounding_cube.length,0.0},
          {0.0,0.0,bounding_cube.length},
        },
        origin={
           bounding_cube.length-2*elemsize+eps,
          -bounding_cube.length/2+eps,
          -bounding_cube.length/2+eps,
        },
      },
    }
  },
  -- north outflow bnd
  {
    attribute = {
      kind = 'boundary',
      label = 'outflowNorth',
      level = minlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {bounding_cube.length,0.0,0.0},
          {0.0,0.0,bounding_cube.length},
        },
        origin={
          -elemsize+eps,
          bounding_cube.length/2-2*elemsize+eps,
          -bounding_cube.length/2+eps
        },
      },
    }
  },
  -- south outflow bnd
  {
    attribute = {
      kind = 'boundary',
      label = 'outflowSouth',
      level = minlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {bounding_cube.length,0.0,0.0},
          {0.0,0.0,bounding_cube.length},
        },
        origin={
          -elemsize+eps,
          -bounding_cube.length/2+2*elemsize-eps,
          -bounding_cube.length/2+eps
        },
      },
    }
  },
  -- top outflow
  {
    attribute = {
      kind = 'boundary',
      label = 'outflowTop',
      level = minlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {bounding_cube.length,0.0,0.0},
          {0.0,bounding_cube.length,0.0},
        },
        origin={
          -eps,
          -bounding_cube.length/2+eps,
          bounding_cube.length/2-2*elemsize+eps,
        },
      }
    },
  },
  -- bottom outflow
  { 
    attribute = {
      kind = 'boundary',
      label = 'outflowBottom',
      level = minlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {bounding_cube.length,0.0,0.0},
          {0.0,bounding_cube.length,0.0},
        },
        origin={
          -eps,
          -bounding_cube.length/2+eps,
          -bounding_cube.length/2+2*elemsize-eps,
        },
      }
    }
  },
  -- seed 
  {
    attribute = {
      kind = 'seed'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {bounding_cube.length/2,0.0,0.0 },
      },
    },
  },
}
	    
