-- Use this file as template. Do not modify this file for running some testcases

-- PARAMETERS TO VARY FOR PLATE ------------------
-- size of the element
dx = 1/50

-- Set the height and the length of the channel 
H = dx
Lch = 1.0

-- PARAMETERS TO VARY FOR PLATE ------------------

outputname = 'plate'
outputpreview = true

coarsestLevel = 5
--minlevel = coarsestLevel+1

-- The length of the bounding cube
--cubeLength = 16.0

folder = "./mesh/"





ebug = {debugMode = true, debugMesh = 'debug/'}

minlevel = math.ceil(math.log(2*Lch/dx)/math.log(2))
print(minlevel)
cubeLength = dx*2^minlevel
print(cubeLength)
largeeps = cubeLength/(2^coarsestLevel)

-- The diameter of the cube in the center
--diameter = 0.25


bounding_cube = {
                 origin = {-2*dx,-2*dx,-2*dx},
                 length = cubeLength
                }


eps = cubeLength/2^(minlevel+2)
spatial_object = 
                {
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'west',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,H+eps,0.0},
                                                  {0.0,0.0,cubeLength},
                                                },
                                           origin={
                                                     -eps,
                                                     -eps,
                                                     -eps,
                                                  },
                                          },
                              }
                  },
                  -- eastern outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'east',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,H+eps,0.0},
                                                  {0.0,0.0,cubeLength},
                                                },
                                           origin={
                                                   Lch+eps, 
                                                   -eps, 
                                                   -eps, 
                                                  },
                                          },
                              }
                  },
                 -- periodic in Z direction
                 {
                  attribute = {
                                kind = 'periodic',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'periodic',
                                object = 
                                         {
                                          plane1 = {
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,bounding_cube.length,0.0},
                                                          },
                                                     origin={-eps,-eps,-eps},
                                                   },
                                          plane2 = {
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,bounding_cube.length,0.0},
                                                          },
                                                     origin={-eps,-eps,dx+eps},
                                                   },
                                         }
                             }
                 },

                 -- periodic in Y direction
                 {
                  attribute = {
                                kind = 'periodic',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'periodic',
                                object = 
                                         {
                                          plane1 = {
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,0.0,bounding_cube.length },
                                                          },
                                                     origin={-eps,-eps,-eps},
                                                   },
                                          plane2 = {
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0, 0.0, bounding_cube.length,},
                                                          },
                                                     origin={-eps,H + eps,-eps},
                                                   },
                                         }
                             }
                 },
                --  {
                --   attribute = {
                --                 kind = 'boundary',
                --                 label = 'centerwall',
                --                 level = minlevel,
                --               },
                --   geometry = {
                --                 kind = 'canoND',
                --                 object = 
                --                          {
                --                           vec= {
                --                                  {0.0,H + eps,0.0},
                --                                  {0.0,0.0,bounding_cube.length},
                --                                },
                --                           origin={
                --                                    4*dx + eps,
                --                                    -eps,
                --                                    -eps
                --                                  },
                --                          },
                --              }
                --  },
                  -- the plate in the middle
--                  {
--                   attribute = {
--                                 kind = 'boundary',
--                                 label = 'cube',
--                                 level = minlevel,
--                               },
--                   geometry = {
--                                 kind = 'canoND',
--                                 object = 
--                                          {
--                                           vec= {
--                                                  {diameter-2*eps,0.0,0.0},
--                                                  {0.0,diameter-2*eps,0.0},
--                                                  {0.0,0.0,2*dx},
--                                                },
--                                           origin={
--                                                    5.0-diameter/2,
--                                                    5.0-diameter/2, 
--                                                    -eps
--                                                  },
--                                          },
--                              }
--                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object = { 
                                          {
                                             origin = {Lch/4,H/4,eps},

                                          },
                                         -- {
                                         --    origin = {5*dx + eps,H/4,eps},

                                         -- },
                                       }
                             },
                  },
                }
	    
