-- Configuration file for Ateles --
require('seeder')
logging = { level = 5 }

-- the order of the scheme: has to be a power of 2
spatial_order = 16

-- global simulation options
sim_name = 'naca0012' 
sim_control = {
                time_control = {   
                                 max = 75.0*domain_fac,
                                 interval = { iter = 100 },
                               }
             }
--print('Physical simulation time: ', sim_control.time_control.max)

-- Mesh definitions --
mesh = 'mesh/'

-- Restart settings
io_buffer_size = 10
restart = { 
            --read  = './restart/simulation_lastHeader.lua',
            write = './restart/',                                        
            time_control = {   
                            min = 0, 
                            max = sim_control.time_control.max, 
                            interval = sim_control.time_control.max/100,
                           },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- ...the initial condition table. 
isen = 1.4
boltz= 296
rho  = 1.0
p    = 1.0
-- ... define background velocity (ATTENTION: change boundaries accordingly)
vel  = 0.3 * math.sqrt(isen * p / rho ) --TODO 0.6 --TODO 1.1
-- ... define the temperature in the penalization area
temp = p / ( rho * boltz )

-- ... the smallness parameter of the penalization
penalization_eps = 8.0/spatial_order 
penalization_alpha = 1.0 --TODO 0.1 --TODO = 0.01

-- NACA0030 description
-- ... the scaling factor of the profile (x and y direction)
scale = airfoil_length --TODO 3.0/2/2
function inside_naca(x_phys,y_phys,z_phys)
  x_naca = x_phys/scale + 0.5
  y_naca = y_phys/scale - 0.01
  thickness = (profile/100.0/0.2) * ( 0.2969 * math.sqrt(x_naca) - 0.1260*x_naca - 0.3516*x_naca*x_naca + 0.2843*x_naca*x_naca*x_naca - 0.1036*x_naca*x_naca*x_naca*x_naca )
  if x_naca >= 0.0 and x_naca <= 1.0 then
    if y_naca >= 0.0 then
      if y_naca <= thickness then
        return 1.0
      else
        return 0.0
      end
    else
      if y_naca >= -thickness then
        return 1.0
      else
        return 0.0
      end
    end 
  else
    return 0.0
  end
end 

function obstacle_function(x,y,z,t)
  if inside_naca(x,y,z) > 0.0 then
    return { 1.0, 0.0, 0.0, temp }
  else
    return { 0.0, 0.0, 0.0, 0.0 }
  end
end

-- Initial condition definitions --
function iniVel(x,y,z)
  if inside_naca(x,y,z) > 0.0 then
    return 0.0
  else
    return vel
  end
end
initial_condition = { 
                      density  = rho,
                      pressure = p,
                      velocityX = iniVel,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }

-- Check for Nans and unphysical values
check =  {
           interval = 1,
         }

-- Scheme definitions --
scheme = {
    spatial =  {
                  name = 'modg_2d',          
                  m = spatial_order-1,                 
               }, 
    temporal = {
               name = 'explicitRungeKutta',
               steps = 4,
               --   name = 'explicitSSPRungeKutta',  
               --   steps = 2,
                  control = {
                             name     = 'cfl', 
                             cfl      = 0.1,
                             cfl_visc = 0.1,
                            },
               },
--     stabilization = {
--                       {
--                          name = 'spectral_viscosity',
--                          alpha = 32,
--                          order = 50,
--                       },
--     --                   {
--     --                      name = 'cons_positivity_preserv',
--     --                      eps = 1e-6,
--     --                   },
--                     }
}


-- ...the general projection table
projection = {
              kind = 'fpt', 
              lobattoPoints = true,
              factor = 1.0,  
              blocksize = 32,
              -- fftmultithread = true, 
             }

-- Boundary conditions
boundary_condition = {
                        { 
                         label = 'west', 
                         --TODO kind = 'supersonic_inflow_normal',
                         kind = 'inflow_normal',
                         density = rho,
                         v_norm = iniVel,
                         v_tan = 0.0,
                         pressure = p,
                        }
                         ,
                        { 
                         label = 'east', 
                         --TODO kind = 'supersonic_outflow',
                         kind = 'outflow',
                         pressure = p,
                         }
                         ,
                        { 
                         label = 'south', 
                         kind = 'slipwall', 
                         }
                         ,
                        { 
                         label = 'north', 
                         kind = 'slipwall', 
                         }
}

---- Sponge definition
--source = {
--  spongeLayer = {
--    shape = {   
--      kind = 'canoND',
--      object= {
--        origin = { 0.0, -cubeLength/2, -cubeLength/2 },
--        vec = { 
--          { cubeLength, 0, 0 },
--          { 0, cubeLength, 0 },
--          { 0, 0, cubeLength }
--        },
--        segments = {
--          2 * cubeLength / elemsize,
--          2 * cubeLength / elemsize,
--          2 * cubeLength / elemsize
--        }
--      } 
--    },
--    kind = 'combined',
--    spatial = { 
--      predefined = 'spongeLayer_2d', 
--      plane_origin = { cubeLength / 8, 0.0, 0 },
--      plane_normal = { 1.0, 0, 0 },
--      damp_factor = 1,
----      damp_exponent = {},
--      target_state = {
--        density = rho,
--        velx = vel,
--        vely = 0.0,
--        pressure= p
--      }
--    }
--  }
--}
