-- Configuration file for Ateles --
sim_name = 'cylinder'
sim_control = {
                time_control = {   
                                 max = {clock = 3600*2-300, sim = 1.0},
                                 interval = { iter = 10 },
                               },
                abort_criteria = { stop_file = 'stop',
                                 }
             }
logging = { level = 10 }

-- Check for Nans and unphysical values
check =  { interval = 1 }


-- the order of the scheme:
spatial_order = 12
filter_order = 15 

-- Restart settings
io_buffer_size = 20
restart = { 
            read  = 'restart/rest_alpha_12_eps02_inlet/simulation_lastHeader.lua',
            write = 'restart/rest_alpha_12_eps02_inlet/',                                        
            time_control = {   
                            min = 0, 
                            max = sim_control.time_control.max.sim, 
                            interval = {sim=0.001}, --0.001,
                           },  
          }

-- ...the initial condition table. 
isen = 1.4
boltz= 287.058 --1.0/1.4
rho  = 1.225
p    = 101325.0
-- ... define background velocity (ATTENTION: change boundaries accordingly)
vel  = 2.0 --* math.sqrt(isen * p / rho ) --TODO 0.6 --TODO 1.1

-- ... define the temperature in the penalization area
temp = p / ( rho * boltz )

-- ... the smallness parameter of the penalization
penalization_eps = 0.2
penalization_alpha = penalization_eps  --TODO 0.1 --TODO = 0.01
penalization_alphaTemp = (isen -1) --TODO 0.1 --TODO = 0.01

mesh = './mesh/'

function sign(x)
   if x<0 then
     return -1
   elseif x>0 then
     return 1
   else
     return 0
   end
end

Ax = 0.05
Ay = 0.04
Bx = 0.075
By = 0.05
Cx = 0.25
Cy = 0.04
Dx = 0.05
Dy = 0.08
Ex = 0.25
Ey = 0.08
Fx = 0.075
Fy = 0.07

function obstacle_function(x,y,z,t)
  ax = Ax -x
  ay = Ay -y
  bx = Bx -x
  by = By -y
  cx = Cx -x
  cy = Cy -y
  dx = Dx -x
  dy = Dy -y
  ex = Ex -x
  ey = Ey -y
  fx = Fx -x
  fy = Fy -y
  --length of each vector
  a = math.sqrt(ax*ax + ay*ay)
  b = math.sqrt(bx*bx + by*by)
  c = math.sqrt(cx*cx + cy*cy)
  d = math.sqrt(dx*dx + dy*dy)
  e = math.sqrt(ex*ex + ey*ey)
  f = math.sqrt(fx*fx + fy*fy)
  -- geth the angles
  -- between a and b
  alpha = sign(ax*by - ay*bx)*math.acos( (ax*bx + ay*by)/(a*b) )
  beta  = sign(bx*cy - by*cx)*math.acos( (bx*cx + by*cy)/(b*c) )
  gamma = sign(cx*ay - cy*ax)*math.acos( (cx*ax + cy*ay)/(c*a) )
  delta = sign(dx*ey - dy*ex)*math.acos( (dx*ex + dy*ey)/(d*e) )
  eps   = sign(ex*fy - ey*fx)*math.acos( (ex*fx + ey*fy)/(e*f) )
  zeta  = sign(fx*dy - fy*dx)*math.acos( (fx*dx + fy*dy)/(f*d) )
--  print(alpha+beta+gamma)
  if math.abs(alpha + beta + gamma + delta + eps + zeta) > math.pi then
    return { 1.0, 0.0, 0.0, temp }
  else
    return { 0.0, 0.0, 0.0, 0.0 }
  end
end

-- Initial condition definitions --
function iniVel(x,y,z)
  ax = Ax -x
  ay = Ay -y
  bx = Bx -x
  by = By -y
  cx = Cx -x
  cy = Cy -y
  dx = Dx -x
  dy = Dy -y
  ex = Ex -x
  ey = Ey -y
  fx = Fx -x
  fy = Fy -y
  --length of each vector
  a = math.sqrt(ax*ax + ay*ay)
  b = math.sqrt(bx*bx + by*by)
  c = math.sqrt(cx*cx + cy*cy)
  d = math.sqrt(dx*dx + dy*dy)
  e = math.sqrt(ex*ex + ey*ey)
  f = math.sqrt(fx*fx + fy*fy)
  -- geth the angles
  -- between a and b
  alpha = sign(ax*by - ay*bx)*math.acos( (ax*bx + ay*by)/(a*b) )
  beta  = sign(bx*cy - by*cx)*math.acos( (bx*cx + by*cy)/(b*c) )
  gamma = sign(cx*ay - cy*ax)*math.acos( (cx*ax + cy*ay)/(c*a) )
  delta = sign(dx*ey - dy*ex)*math.acos( (dx*ex + dy*ey)/(d*e) )
  eps   = sign(ex*fy - ey*fx)*math.acos( (ex*fx + ey*fy)/(e*f) )
  zeta  = sign(fx*dy - fy*dx)*math.acos( (fx*dx + fy*dy)/(f*d) )
--  print(alpha+beta+gamma)
  if math.abs(alpha + beta + gamma + delta + eps + zeta) > math.pi then
    return 0.0
  else
    return vel
  end
end

function rampVel(x,y,z)
 
 return 
end

-- Scheme definitions --
scheme = {
    spatial =  {
                  name = 'modg_2d',          
                  m = spatial_order-1,                 
               }, 
    temporal = {
               name = 'explicitRungeKutta',
               steps = 4,
               --   name = 'explicitSSPRungeKutta',  
               --   steps = 2,
                  control = {
                             name     = 'cfl', 
                             cfl      = 0.8,
                             --cfl_visc = 0.1,
                            },
               },
     stabilization = {
                       {
                          name = 'spectral_viscosity',
                          alpha = 32,
                          order =filter_order,
                       },
                       {
                          name = 'covolume',
                          alpha = 36,
                          order = filter_order,
                          beta = 1.0 - 2.0/spatial_order,
                         }
--     --                   {
--     --                      name = 'cons_positivity_preserv',
--     --                      eps = 1e-6,
--     --                   },
                     }
}


-- ...the general projection table
projection = {
              kind = 'fpt',
              -- lobattoPoints = true,
              factor = 3.0,
              blocksize = 32,
              -- fftmultithread = true,
             }

-- Equation definitions --
equation = {
    name   = 'euler_2d',                 
    -- The definition of an obstacle by penalization
    penalization = {
                     {
                        kind = 'lua_fun',
                        fun = obstacle_function,
                        shape={ 
                                  kind = 'canoND',
                                  object = {origin = {0.04, 0.03, 0.00125/2},
                                            vec = { {0.22,0.0,0.0},{0.0,0.06,0.0} },
                                            segments = {2200,600}, 
                                           }
                              }
                     },
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
    -- Physical parameters of the gas phase
    isen_coef            = isen,
    r                    = boltz,
    -- Parameters of the penalization
    porosity             = penalization_eps,
    viscous_permeability = penalization_alpha*penalization_eps,
    thermal_permeability = penalization_alphaTemp*penalization_eps,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

initial_condition = { 
                      density  = rho,
                      pressure = p,
                      velocityX = 0.0, --iniVel,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }
-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'West',  
                       kind = 'inflow_normal',      
                       density = rho,
                       v_norm = { kind = "combined", spatial = vel,
                                  temporal = {  predefined = 'smooth',
                                  		from_time = 0.0 , to_time = 0.005,
                                  		min_factor = 0.0 , max_factor=1.0,
					     },
                                 },
                       v_tan = 0.0,
                       }
                       ,
                       { 
                       label = 'East',  
                       kind = 'outflow',       
                       pressure = p,
                       }
                       ,
                       { 
                       label = 'South', 
                       kind = 'outflow',       
                       pressure = p,
                       }
                       ,
                       { 
                       label = 'North', 
                       kind = 'outflow',       
                       pressure = p,
                       }
                       ,
                       { 
                       label = 'Top', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'Bottom', 
                       kind = 'slipwall',       
                       }
                       ,
                     }  
