-- Use this file as template. Do not modify this file for running some testcases

outputname = 'raylTayl'
outputpreview = true 

-- ATTENTION: minlevel has to be larger than 1
minlevel = 5

cubeLength = 4.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

-- smallness parameter
eps = bounding_cube.length/(2^(minlevel+5))

-- the size of an element
elemsize = bounding_cube.length/(2^(minlevel))

spatial_object = 
                {
                  -- slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    -eps,
                                                  },
                                          },
                              }
                  },
                  -- slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    elemsize+eps,
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipBottom',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+elemsize-eps,
                                                    -bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipTop',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    bounding_cube.length/2-elemsize+eps,
                                                    -bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  -- periodic boundary in x direction
                  {
                    attribute = {
                                 kind = 'periodic',
                                 level = minlevel,
                                },
                    geometry = {
                                 kind = 'periodic',
                                 object = { 
                                            plane1={
                                                      vec= {
                                                             {0.0,0.0,bounding_cube.length},
                                                             {0.0,bounding_cube.length,0.0},
                                                           },
                                                      origin={
                                                               -eps,
                                                               -bounding_cube.length/2+eps,
                                                               -bounding_cube.length/2+eps,
                                                             },
                                                   },
                                            plane2={
                                                      vec= {
                                                             {0.0,bounding_cube.length,0.0},
                                                             {0.0,0.0,bounding_cube.length},
                                                           },
                                                      origin={
                                                               bounding_cube.length/2-elemsize+eps,
                                                               -bounding_cube.length/2+eps,
                                                               -bounding_cube.length/2+eps,
                                                             },
                                                   },
                                          },
                               },
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0,0,0},

                                        },
                             },
                  },
                }
