-- Configuration file for Ateles --
require('common')

-- Scheme definitions --
scheme = {
    spatial =  {
        name = 'modg',          
        m = degree
    },
    temporal = {
        name = 'explicitRungeKutta',
        steps = 4,
        control = {
            name     = 'cfl', 
            cfl      = cfl,
            cfl_visc = cfl_visc
        }
    }
}

-- Equation definitions 
equation = {
    name      = 'navier_stokes',
    isen_coef = isen,
    r         = boltz,
    -- Viscous parameters
    therm_cond = conducT,
    mu         = mu,
    ip_param   = c2*3*(degree+2)/(2*(degree+3)),
    material = {
        characteristic = 0.0,
        relax_velocity = {0.0, 0.0, 0.0},
        relax_temperature = 0.0
    }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

initial_condition["velocityZ"] = 0.0
