-- Use this file as template. Do not modify this file for running some testcases

outputname = 'shock_vort'
outputpreview = true 


-- fix minimum level to 2
minlevel = 2

-- the refinement level of the plane
refinelevel = 6

cubeLength = 20.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

largeeps = cubeLength/math.pow(2,minlevel)
smalleps = cubeLength/math.pow(2,refinelevel)

eps = 1e-7

spatial_object = 
                {
                  -- eastern inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflow',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     (-1)*largeeps-eps ,
                                                     (-1)*bounding_cube.length/2+eps,
                                                     (-1)*bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflow',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   largeeps+eps, 
                                                   -bounding_cube.length/2+eps, 
                                                   -bounding_cube.length/2+eps, 
                                                  },
                                          },
                              }
                  },
------------------------------------------
------------------------------------------
------------------------------------------
                  -- periodic boundary in y direction
                  {
                    attribute = {
                                 kind = 'periodic',
                                 level = refinelevel,
                                },
                    geometry = {
                                 kind = 'periodic',
                                 object = { 
                                            plane1={
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,0.0,bounding_cube.length},
                                                          },
                                                     origin={
                                                              -bounding_cube.length/2+eps,
                                                              -largeeps-eps,
                                                              -bounding_cube.length/2+eps
                                                            },
                                                   },
                                            plane2={
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,0.0,bounding_cube.length},
                                                          },
                                                     origin={
                                                              -bounding_cube.length/2+eps,
                                                              largeeps+eps,
                                                              -bounding_cube.length/2+eps
                                                            },
                                                   },
                                          },
                               },
                  },
------------------------------------------
------------------------------------------
------------------------------------------
------------------------------------------
--TODO                  -- southern slip bnd
--TODO                  {
--TODO                   attribute = {
--TODO                                 kind = 'boundary',
--TODO                                 label = 'slipSouth',
--TODO                                 level = minlevel,
--TODO                               },
--TODO                   geometry = {
--TODO                                 kind = 'canoND',
--TODO                                 object = 
--TODO                                          {
--TODO                                           vec= {
--TODO                                                  {bounding_cube.length,0.0,0.0},
--TODO                                                  {0.0,0.0,bounding_cube.length},
--TODO                                                },
--TODO                                           origin={
--TODO                                                    -bounding_cube.length/2+eps,
--TODO                                                    -largeeps-eps,
--TODO                                                    -bounding_cube.length/2+eps
--TODO                                                  },
--TODO                                          },
--TODO                              }
--TODO                  },
--TODO                  -- northern slip bnd
--TODO                  {
--TODO                   attribute = {
--TODO                                 kind = 'boundary',
--TODO                                 label = 'slipNorth',
--TODO                                 level = minlevel,
--TODO                               },
--TODO                   geometry = {
--TODO                                 kind = 'canoND',
--TODO                                 object = 
--TODO                                          {
--TODO                                           vec= {
--TODO                                                  {bounding_cube.length,0.0,0.0},
--TODO                                                  {0.0,0.0,bounding_cube.length},
--TODO                                                },
--TODO                                           origin={
--TODO                                                    -bounding_cube.length/2+eps,
--TODO                                                    largeeps+eps,
--TODO                                                    -bounding_cube.length/2+eps
--TODO                                                  },
--TODO                                          },
--TODO                              }
--TODO                  },
--------------------------------------------
--------------------------------------------
--------------------------------------------
                  -- periodic boundary in z direction
                  {
                    attribute = {
                                 kind = 'periodic',
                                 level = refinelevel,
                                },
                    geometry = {
                                 kind = 'periodic',
                                 object = { 
                                            plane1={
                                                       vec= {
                                                              {bounding_cube.length,0.0,0.0},
                                                              {0.0,bounding_cube.length,0.0},
                                                            },
                                                       origin={
                                                                -bounding_cube.length/2+eps,
                                                                -bounding_cube.length/2+eps,
                                                                -eps
                                                              },
                                                   },
                                            plane2={
                                                       vec= {
                                                              {bounding_cube.length,0.0,0.0},
                                                              {0.0,bounding_cube.length,0.0},
                                                            },
                                                       origin={
                                                                -bounding_cube.length/2+eps,
                                                                -bounding_cube.length/2+eps,
                                                                smalleps+eps
                                                              },
                                                   },
                                          },
                               },
                  },
--------------------------------------------
--------------------------------------------
--------------------------------------------
--TODO                  -- bottom slip bnd
--TODO                  {
--TODO                   attribute = {
--TODO                                 kind = 'boundary',
--TODO                                 label = 'slipBottom',
--TODO                                 level = refinelevel,
--TODO                               },
--TODO                   geometry = {
--TODO                                 kind = 'canoND',
--TODO                                 object = 
--TODO                                          {
--TODO                                           vec= {
--TODO                                                  {bounding_cube.length,0.0,0.0},
--TODO                                                  {0.0,bounding_cube.length,0.0},
--TODO                                                },
--TODO                                           origin={
--TODO                                                    -bounding_cube.length/2+eps,
--TODO                                                    -bounding_cube.length/2+eps,
--TODO                                                    -eps
--TODO                                                  },
--TODO                                          },
--TODO                              }
--TODO                  },
--TODO                  -- top slip bnd
--TODO                  {
--TODO                   attribute = {
--TODO                                 kind = 'boundary',
--TODO                                 label = 'slipTop',
--TODO                                 level = refinelevel,
--TODO                               },
--TODO                   geometry = {
--TODO                                 kind = 'canoND',
--TODO                                 object = 
--TODO                                          {
--TODO                                           vec= {
--TODO                                                  {bounding_cube.length,0.0,0.0},
--TODO                                                  {0.0,bounding_cube.length,0.0},
--TODO                                                },
--TODO                                           origin={
--TODO                                                    -bounding_cube.length/2+eps,
--TODO                                                    -bounding_cube.length/2+eps,
--TODO                                                    smalleps+eps
--TODO                                                  },
--TODO                                          },
--TODO                              }
--TODO                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0,0,0},

                                        },
                             },
                  },
                }
	    
