require 'common'

-- simulation controll parameter-----------------------------------------------
timing_file = 'timing.res'
simulation_name='ateles_2d' 

sim_control = {
  time_control = {
    min = 0,
    max = tmax,
    interval = {iter = 100}, -- final simulation time
  }
}

-- Restart -------------------------------------------------------------------
NOrestart = {
  write = 'restart/',
  time_control = {
    min = 0,
    max = tmax,
    interval = {sim = restart_dt, clock = 7000}, -- final simulation time
  },
}

-- Tracking
segments = 60*(degree+1)
tracking = {
  -- Line tracking
  {
    label = 'lineX_pressure',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { -30.0, 0.0, 0.0 },
        vec      = { 60.0, 0.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineY_pressure',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, -30.0, 0.0 },
        vec      = { 0.0, 60.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt },
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'lineZ_pressure',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { 0.0, 0.0, -30.0 },
        vec      = { 0.0, 0.0 ,60.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  {
    label = 'center',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        { origin = { 0.0, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval = {iter=1}},
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'pre_west',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -9.99,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'post_west',
    folder = './track_pulse/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -10.01,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_2d/'

-- Variable system definintion-------------------------------------------------
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 2,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
  {
     name = 'ref_pressure',
     ncomponents = 1,
     vartype ='st_fun',
     st_fun = { 
       predefined = 'acoustic_pulse',
       center     = gp_center,
       halfwidth  = gp_halfwidth,
       amplitude  = gp_amplitude,
       background = gp_background,
       speed_of_sound = gp_c,
     }
  },
  {
     name = 'error',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'pressure', 'ref_pressure'},
    }
  },
}

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg_2d',
    modg_space = 'Q',
    m = degree,
  },
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitSSPRungeKutta',
    steps = 2,
    control = {
      name = 'fixed',
      dt = dt
    },
  },
}

-- Equation definitions -------------------------------------------------------
penalization_eps = 8.0/(degree+1)
penalization_alpha = 1.0
equation = {
  penalization = {
    global = {
      kind = 'const',
      const = {0.0, 0.0, 0.0, 0.0},
    },
  },
  name       = 'navier_stokes_2d',
  isen_coef  = 1.4,
  r          = 280.0,
  therm_cond = 0.5, 
  mu         = 1.0e-4,  
  ip_param   = 4.0, 
  -- Parameters of the penalization
  porosity             = penalization_eps,
  viscous_permeability = penalization_alpha*penalization_eps,
  thermal_permeability = penalization_alpha*penalization_eps,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


 -- Boundary definitions
boundary_condition = {
  {
    label = 'outside',
    kind = 'grad_primitives',
    density = dens,
    velocityX = velX,
    velocityY = velY,
    pressure  = press,
    grad_density   = 0.0,
    grad_velocityX = 0.0, 
    grad_velocityY = 0.0,
    grad_pressure  = 0.0,
  },
}
