#!/bin/bash

rm -rf mesh
rm -rf restart
rm -rf harvest
rm -rf plots

mkdir mesh
mkdir restart
mkdir harvest

../../../../../seeder/build/debug/seeder

# Run the solver ...
mpirun -n 16 ../../../../build/ateles

# Raw-data to VTK ...
../../../../../harvester_default/build/debug/harvester


rm -rf restart_postProcessed
rm -rf harvest_postProcessed

mkdir restart_postProcessed
mkdir harvest_postProcessed

# Post-process the data
mpirun -n 8 ../../../../build/ateles ateles_postProcess.lua

# Post-processed data to VTK ...
../../../../../harvester_default/build/debug/harvester harvester_postProcess.lua

# Create a plot with gnuplot
mkdir plots
gnuplot gnuplot_script.pl
