######################################## TEX FILES ###############################################################

reset
set terminal latex
set out "plots/sod_density.tex"

set xlabel '$x$'
set ylabel "\\rotatebox{90}{density}"

plot './toro1_exact.dat' u 1:2 w l title 'exact', \
     './harvest/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:4 w l title 'raw', \
     './harvest_postProcessed/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:4 w l title 'post-processed'


reset
set terminal latex
set out "plots/sod_velocity.tex"

set xlabel '$x$'
set ylabel "\\rotatebox{90}{velocity}"

plot './toro1_exact.dat' u 1:3 w l title 'exact', \
     './harvest/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:5 w l title 'raw', \
     './harvest_postProcessed/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:5 w l title 'post-processed'


reset
set terminal latex
set out "plots/sod_pressure.tex"

set xlabel '$x$'
set ylabel "\\rotatebox{90}{pressure}"

plot './toro1_exact.dat' u 1:6 w l title 'exact', \
     './harvest/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:6 w l title 'raw', \
     './harvest_postProcessed/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:6 w l title 'post-processed'

######################################## EPS FILES ###############################################################

reset
set terminal post enh eps color solid
set out "plots/sod_density.eps"

set xlabel 'x'
set ylabel 'density'

plot './toro1_exact.dat' u 1:2 w l title 'exact', \
     './harvest/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:4 w l title 'raw', \
     './harvest_postProcessed/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:4 w l title 'post-processed'


reset
set terminal post enh eps color solid
set out "plots/sod_velocity.eps"

set xlabel 'x'
set ylabel 'velocity'

plot './toro1_exact.dat' u 1:3 w l title 'exact', \
     './harvest/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:5 w l title 'raw', \
     './harvest_postProcessed/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:5 w l title 'post-processed'


reset
set terminal post enh eps color solid
set out "plots/sod_pressure.eps"

set xlabel 'x'
set ylabel 'pressure'

plot './toro1_exact.dat' u 1:6 w l title 'exact', \
     './harvest/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:6 w l title 'raw', \
     './harvest_postProcessed/toro1_x_euler_modg_1d_track_p00000_t250.000E-03.res' u 1:6 w l title 'post-processed'
