require('seeder')

timestep_info = 1
timing_file = 'timing.res'         -- the filename of the timing results

-- global simulation options
simulation_name = 'toro1_y_euler_modg_2d'
sim_control = {
                time_control = {
                  min = 0,
                  max = 0.025
                }
              }

-- Mesh definitions --
mesh = './mesh/'

characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  -- This is the global material for Euler 1D. It consists of three different 
  -- components, characteristics with one scalar, relax_velocity with one 
  -- scalar and relax_temperature with one scalar, thus we need three scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a 
  -- neutral term, which in this case is 0.
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 2,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
}

-- Equation definitions --
equation = {
    name   = 'euler_2d',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
    material = {
                 characteristic = 'characteristic',
                 relax_velocity = 'relax_velocity',
                 relax_temperature = 'relax_temperature'

               }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Tracking              
tracking = { 
             label = 'probe_density_Q4_toro_y',
             folder = './',
             variable = {'density'}, 
             shape = {
                      kind = 'canoND', 
                      object= { origin = {
                                           epsx, 
                                           (channel_length/2.0) + epsx, 
                                           epsx
                                         } 
                              } 
                     },
             time_control = {
               min = 0, 
               max = sim_control.time_control.max, 
               interval = sim_control.time_control.max/20.0
             },  
             output = { format = 'ascii', ndofs = 1 }, -- 'asciiSpatial', 'harvester', 'convergence'
 }

-- The initial conditions for the Riemann problem
-- ... left state
rho_l = 1.0
u_l = 0.0
p_l = 1.0
-- ... right state
rho_r = 0.125
u_r = 0.0
p_r = 0.1

function rho(x,y,z)
    if( y < channel_length/2.0 ) then
        return rho_l
    else
        return rho_r
    end
end

function p(x,y,z)
    if( y < channel_length/2.0 ) then
        return p_l
    else
        return p_r
    end
end

function u(x,y,z)
    if( y < channel_length/2.0 ) then
        return u_l
    else
        return u_r
    end
end

function velX(x,y,z)
    return 0.0
end

function velY(x,y,z)
    return u(x,y,z)
end

projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattoPoints = false  -- if lobatto points should be used, default = false
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              blocksize = 32,        -- for fpt, default -1
           -- fftMultiThread = false -- for fpt, logical, default false
             }
initial_condition = { 
                      density = rho,
                      pressure = p,
                      velocityX = velX,
                      velocityY = velY,
             }

-- Scheme definitions --
scheme = {
           -- the spatial discretization scheme
           spatial =  {
                      name = 'modg_2d',             
                      m =  3,                  
                      }, 
           -- the temporal discretization scheme
           temporal = {
                      name = 'explicitRungeKutta',  
                      steps = 4,
                      control = {
                                 name = 'cfl',   
                                 cfl  = 0.6,     
                                },
                      },
}

-- Boundary conditions
boundary_condition = {
        { 
         label = 'inlet', 
         kind = 'inflow_normal',
         density = rho_l,
         v_norm = u_l,
         v_tan = 0.0,
	}
         ,
        { 
         label = 'outlet', 
         kind = 'outflow',
         pressure = p_r,
         }
         ,
        { 
         label = 'bottom', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'top', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'south', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'north', 
         kind = 'slipwall', 
         }
}


