-- ...the uniform refinement level for the periodic cube
level = 2
-- ...the length of the cube
cubeLength = 3.0*math.pi

const = 2.0/3.0

logging = {level = 3}

-- Mesh definitions --
mesh = { 
  predefined = 'cube',
  origin = {
    (-1.0)*cubeLength/2.0,
    (-1.0)*cubeLength/2.0,
    (-1.0)*cubeLength/2.0
  },
  length = cubeLength,
  refinementLevel = level
}

-- global simulation options
sim_name = 'heat_modg' -- the name of the simualtion

sim_control = {
  time_control = {
    min = 0,
    max = 0.06 -- final simulation time
    --max = {iter = 820} -- final simulation time
  }
}

-- Equation definitions --
equation = {
    name   = 'heat',                   -- we solve the 1d_Heat equations
    k = 1,                                 --  thermal diffusivity
    --rho = ,                               -- Mass density 
}

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
    m = 6,                    -- the maximal polynomial degree for each spatial direction
  },
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitRungeKutta',  --'explicitEuler',
    steps = 4,
    -- how to control the timestep
    control = {
      name = 'cfl',   -- the name of the timestep control mechanism
      cfl      = 0.5,     -- CourantFriedrichsLewy number
      cfl_visc = 0.5,     -- CourantFriedrichsLewy number
    }
  }
}

--function tempX(x,y,z)
-- --if x < 0.25 and x > -0.25 then
-- if x < 0.0  then
--   return 10.0
-- else
--   return 1.0
-- end
--end

--function tempX(x,y,z)
--  d= x*x+y*y 
--  return( 1.225 + 4* math.exp(-d/0.1*math.log(2)) )
--end

function tempX(x,y,z)
  return( math.sin(const*x))
end

initial_condition = {
  temperature = tempX
}

---- Restart settings
--restart = { 
----            -- folder to write restart data to
--            write = './restart/',                                        
--            -- temporal definition of restart write
--            time_control = {   
--              min = 0, 
--              max = {iter=sim_control.time_control.max.iter}, 
--              interval = {iter = sim_control.time_control.max.iter/20.0}
--            }
--          }

-- Restart settings
--restart = { 
----            -- folder to write restart data to
--            write = './restart/',                                        
--            -- temporal definition of restart write
--            time_control = {   
--              min = 0, 
--              max = sim_control.time_control.max, 
--              interval =  sim_control.time_control.max/20.0
--            }
--          }
--
projection = {
  kind = 'fpt', -- 'fpt' or 'l2p', default 'l2p'
                -- for fpt the  nodes are automatically 'chebyshev'
                -- for lep the  nodes are automatically 'gauss-legendre'
  -- lobattoPoints = false  -- if lobatto points should be used, default = false
  factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
  --              blocksize = 32,        -- for fpt, default -1
  --              fftMultiThread = false -- for fpt, logical, default false
}

-- Tracking of a certain variable at a certain point in space over time.           
tracking = {
  -- Give a name for the tracked object.
  label = 'track_temp',
  -- the variable of the solver you track
  variable = {'temperature'},
  -- we track a point at the origin
  shape={
    kind = 'canoND',
    object = {
      origin ={ 0.0, 0.0, 0.0 }
    }
  },
  -- the temporal definition of the tracking: when do we start?
  time_control = {
    min = 0,
    -- the maximum time: max = -1 assigns max=tmax
    max = sim_control.time_control.max,
    interval = sim_control.time_control.max/10.0
  },
  output = { format = 'ascii', ndofs = 1 }, -- 'asciiSpatial', 'harvester', 'convergence'
  folder = './'
}

--
--oundary_condition = {
--                      {
--                       label = 'wallSouth',
--                       kind = 'const',
--                      },
--                      {
--                       label = 'wallNorth',
--                       kind = 'const',
--                      },
--                      {
--                       label = 'wallWest',
--                       kind = 'const',
--                      },
--                      {
--                       label = 'wallEast',
--                       kind = 'const',
--                      }
--                     }
--


