-- Configuration file for Ateles (Periodic Oscillator) --

-- This is a configuration file for the Finite Volume / Discontinuous Galerkin Solver ATELES. 
-- It provides a testcase for the simulation of Acoustic equations in a homogenous media. The simulation domain
-- is a periodic cube with edge length 2.0. Therefore this is a very good way to verify your algorithmic implementations, 
-- since this testcase does not involve any boundary conditions. 
-- The testcase simulates the temporal development of standing waves for acoustic equation. Since we 
-- are considering a very simple domain, an analytic solution is well known and given as Lua functions in this script.
-- Therefore we suggest this testcase to verify one of the following topics
-- ... algorihtmic correctness
-- ... spatial and temporal order of your scheme
-- ... diffusion and dispersion relations of your scheme
-- ... and many more.
-- To verify diffusion and dispersion relations this testcases allows you to modify the spatial harmonics by
-- varying the integer mode number in x and y direction by modifying the lua variables m and n.
-- This testcase can be run in serial (only one execution unit) or in parallel (with multiple mpi ranks).
-- To calculate a grid convergence behavior please modify the level variable. An increment of one will half the radius of your elements.

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- Parameters to vary --
degree = 1
poly_space = 'Q'

logging = { level = 10 }

timestep_info = 100

-- Check for Nans and unphysical values
check =  {
           interval = 100,
         }

--...Configuration of simulation time
simulation_name='ateles_acoustic' 
sim_control = { 
                time_control = { max = {iter=500},  -- final Simulated time
                                 min = 0,
                                 interval = {iter = 100} 
                                }
              }

--...Configuration for the restart file
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = 'restart/',
            -- temporal definition of restart write
            time_control= { 
                            min = 0,
                            interval = {iter=1.0}
                   },
          }

-- table for preCICE
precice = {
           accessor = 'Ateles',
           configFile ='../precice_config.xml',
          }

-- End  Parameters to vary --
--------------------------------------------------------------------------------
-- Definition of the test-case.

-- Mesh definitions --
mesh = 'mesh_ateles/'


-- Equation definitions --
equation = {
             name   = 'acoustic',
             background = {
                 density = 1.0, 
                 velocityX = 0.0,
                 velocityY = 0.0,
                 velocityZ = 0.0,
                 pressure = 1.0
                 }
           }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  degree,                   -- the maximal polynomial degree for each spatial direction
               modg_space = poly_space
               }, 
    -- the temporal discretization scheme
    temporal = {
                 name = 'explicitSSPRungeKutta', 
                 steps = 2,
              -- how to control the timestep
                 control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.95,     -- CourantÐFriedrichsÐLewy number
                         },
               },
             }

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              factor = 1.0
             }


-- Initial Condition definitions --
initial_condition = { 
                      density = 0.0, --init_density, 
                      velocityX = 0.0, --init_velocityX,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }
 -- Boundary definitions
 boundary_condition = {
                         {
                           label = 'acoustic_East',
                           kind = 'outflow',
                           density = '0.0'
                         }
                         ,
                         {
                           label = 'acoustic_West',
                           kind = 'outflow',
                           density = '0.0'
                         }
                         ,
                         {
                           label = 'acoustic_South',
                           kind = 'outflow',
                           density = '0.0'
                         }
                         ,
                         {
                           label = 'acoustic_North',
                           kind = 'outflow',
                           density = '0.0'
                         }
                         ,
                         {
                           label = 'acoustic_Bottom',
                           kind = 'outflow',
                           density = '0.0'
                         }
                         ,
                         {
                           label = 'acoustic_Top',
                           kind = 'outflow',
                           density = '0.0'
                         }
                         ,
                         {
                           label = 'fastest',
                           kind = 'precice',
                           precice_mesh = 'AcousticSurface',
                           provide_mesh = true,
                          -- exchange_data_write = {'Density_right', 
                          --                        'Vel_X_right', 
                          --                        'Vel_Y_right', 
                          --                        'Vel_Z_right'
                          --                        },
                           exchange_data_read =  {'Density', 
                                                  'Velocity_x', 
                                                  'Velocity_y', 
                                                  'Velocity_z'
                                                  }
                         }
                         ,
                       }

--precice_write = {  label = {'precice_rightmesh'} }
