-- Configuration file for Ateles --
require 'seeder_euler'
degree = 3
logging={level=10}

-- global simulation options
simulation_name = 'gauss_euler_modg'             -- the name of the simualtion
sim_control = {
              time_control  = {
                                min = 0.0,
                                max = {iter=100000},                  -- final simulation time
                                interval = {iter=100},
                              },
             }

check = {
          interval = 100,
        }

----...Info for precice
--precice = {
--           accessor = 'Ateles_euler',
--           configFile ='precice_config.xml',
--          }


-- Mesh definitions --
mesh = './mesh_euler/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/euler/',                                        
            -- temporal definition of restart write
            time_control = {   
                            min = 0, 
                            max = {iter=sim_control.time_control.max.iter},  
                            interval = {iter=500}
                           },  
          }


-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m = degree,                   -- the maximal polynomial degree for each spatial direction
               }, 
    -- the temporal discretization scheme
    temporal = {
                name = 'explicitSSPRungeKutta',  -- we use ssp explicit runge kutta in time
                steps = 2,                       -- we have a 2 stage
                control = {                      -- how to control the timestep
                           name = 'cfl',         -- the name of the timestep control mechanism
                           cfl = 0.8           -- Courant Friedrichs Lewy number
                          }
               }
}

initial_condition = { --density = {
                      --           predefined='gausspulse',
                      --           center={0.0, 0.0, 0.0},
                      --           halfwidth=0.20,
                      --           amplitude=2.0,
                      --           background=1.225
                      --          },
                      density=1.225,
                      pressure = {
                                   predefined='gausspulse',
                                   center={0.0, 0.0, 0.0},
                                   halfwidth=0.2,
                                   amplitude=2.0,
                                   background=100000.0
                                 },
                      pressure = 100000.0, 
                      velocityX = 0.0,
                   --   projOverSampling =  1,    -- oversampling for quadrature projeciton of ini cond (per direction)
                   --   useFpt = true,            -- use Fast polynomial transformation to convert to modal representation
                    }

function dens(x,y,z)
  return x
end

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              --blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'euler_East',  
                       kind = 'outflow',
                       pressure = 100000.0,
                       density = 'extrapolate'
--                       kind = 'precice',
--                       precice_mesh = 'AcousticSurface',
--                       provide_mesh = false,
--                       exchange_data_write =  {'Density_euler', 
--                                               'Vel_X_euler', 
--                                               'Vel_Y_euler', 
--                                               'Vel_Z_euler', 
--                                               },
--                       exchange_data_read =  {'Density_acoustic', 
--                                              'Vel_X_acoustic', 
--                                              'Vel_Y_acoustic', 
--                                              'Vel_Z_acoustic',
--                                              'Pressure_acoustic'
--                                             }
                       }
                       ,
                       { 
                       label = 'euler_West',  
                       kind = 'outflow',
                       pressure = 100000.0,
                       density = 'extrapolate'
                      -- kind = 'precice',
                      -- precice_mesh = 'AcousticSurface',
                      -- provide_mesh = false,
                      -- exchange_data_write =  {'Density_euler', 
                      --                         'Vel_X_euler', 
                      --                         'Vel_Y_euler', 
                      --                         'Vel_Z_euler', 
                      --                         },
                      -- exchange_data_read =  {'Density_acoustic', 
                      --                        'Vel_X_acoustic', 
                      --                        'Vel_Y_acoustic', 
                      --                        'Vel_Z_acoustic',
                      --                        'Pressure_acoustic'
                      --                       }
                       }
                       ,
                       { 
                       label = 'euler_South', 
                       kind = 'outflow',
                       pressure = 100000.0,
                       density = 'extrapolate'
                       --kind = 'precice',
                       --precice_mesh = 'AcousticSurface',
                       --provide_mesh = false,
                       --exchange_data_write =  {'Density_euler', 
                       --                        'Vel_X_euler', 
                       --                        'Vel_Y_euler', 
                       --                        'Vel_Z_euler', 
                       --                        },
                       --exchange_data_read =  {'Density_acoustic', 
                       --                       'Vel_X_acoustic', 
                       --                       'Vel_Y_acoustic', 
                       --                       'Vel_Z_acoustic',
                       --                       'Pressure_acoustic'
                       --                      }
                       ----kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'euler_North', 
                       kind = 'outflow',
                       pressure = 100000.0,
                       density = 'extrapolate'
                       --kind = 'precice',
                       --precice_mesh = 'AcousticSurface',
                       --provide_mesh = false,
                       --exchange_data_write =  {'Density_euler', 
                       --                        'Vel_X_euler', 
                       --                        'Vel_Y_euler', 
                       --                        'Vel_Z_euler', 
                       --                        },
                       --exchange_data_read =  {'Density_acoustic', 
                       --                       'Vel_X_acoustic', 
                       --                       'Vel_Y_acoustic', 
                       --                       'Vel_Z_acoustic',
                       --                       'Pressure_acoustic'
                       --                      }
                       --kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'euler_Top', 
                       --kind = 'slipwall',       
                       kind = 'outflow',
                       pressure = 100000.0,
                       density = 'extrapolate'
                       --kind = 'precice',
                       --precice_mesh = 'AcousticSurface',
                       --provide_mesh = false,
                       --exchange_data_write =  {'Density_euler', 
                       --                        'Vel_X_euler', 
                       --                        'Vel_Y_euler', 
                       --                        'Vel_Z_euler', 
                       --                        },
                       --exchange_data_read =  {'Density_acoustic', 
                       --                       'Vel_X_acoustic', 
                       --                       'Vel_Y_acoustic', 
                       --                       'Vel_Z_acoustic',
                       --                       'Pressure_acoustic'
                       --                      }
                       }
                       ,
                       { 
                       label = 'euler_Bottom', 
                       kind = 'outflow',
                       pressure = 100000.0,
                       density = 'extrapolate'
                       --kind = 'precice',
                       --precice_mesh = 'AcousticSurface',
                       --provide_mesh = false,
                       --exchange_data_write =  {'Density_euler', 
                       --                        'Vel_X_euler', 
                       --                        'Vel_Y_euler', 
                       --                        'Vel_Z_euler',
                       --                        },
                       --exchange_data_read =  {'Density_acoustic', 
                       --                       'Vel_X_acoustic', 
                       --                       'Vel_Y_acoustic', 
                       --                       'Vel_Z_acoustic',
                       --                       'Pressure_acoustic'
                       --                      }
                       --kind = 'slipwall',       
                       }
                       ,
                     }  

--precice_write = {  label = {'euler_East', 'euler_West', 'euler_North', 
--                            'euler_South','euler_Bottom', 'euler_Top' }}
