-- Use this file as template. Do not modify this file for running some testcases

outputname = 'jet'
outputpreview = true 
folder = 'mesh_2d/'

-- ATTENTION: the minimum is 3, otherwise you won't get any fluid element.
minlevel = 7

-- the finest level
finelevel = minlevel
finestlevel = minlevel+4

cubeLength = 8.0

-- the largest element
elemsize = cubeLength/(2^minlevel)
elemsize_fine = cubeLength/(2^finelevel)
elemsizeSmall = cubeLength/(2^finestlevel)

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {-elemsize,cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

-- smallness parameter
eps = bounding_cube.length/(2^(finestlevel+3))

-- the diameter of the jet
jetwidth = cubeLength/40

spatial_object = 
                {
               --TODO    -- the refinement boxes at the bottom of the domain
               --TODO    {
               --TODO     attribute = {
               --TODO                   kind = 'refinement',
               --TODO                   level = finelevel,
               --TODO                 },
               --TODO     geometry = {
               --TODO                   kind = 'canoND',
               --TODO                   object = 
               --TODO                            {
               --TODO                             vec= {
               --TODO                                    {2*jetwidth-eps,0.0,0.0},
               --TODO                                    {0.0,2*jetwidth-eps,0.0},
               --TODO                                    {0.0,0.0,10*jetwidth-eps},
               --TODO                                  },
               --TODO                             origin={-jetwidth+eps/2,-jetwidth+eps/2,eps},
               --TODO                            },
               --TODO                }
               --TODO    },
               --TODO    {
               --TODO     attribute = {
               --TODO                   kind = 'refinement',
               --TODO                   level = finestlevel,
               --TODO                 },
               --TODO     geometry = {
               --TODO                   kind = 'canoND',
               --TODO                   object = 
               --TODO                            {
               --TODO                             vec= {
               --TODO                                    {jetwidth-eps,0.0,0.0},
               --TODO                                    {0.0,jetwidth-eps,0.0},
               --TODO                                    {0.0,0.0,5*jetwidth-eps},
               --TODO                                  },
               --TODO                             origin={-jetwidth/2+eps/2,-jetwidth/2+eps/2,eps},
               --TODO                            },
               --TODO                }
               --TODO    },

                  -- west inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflowWest',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -eps,
                                                   -bounding_cube.length/2+eps,
                                                   -bounding_cube.length/2+eps},
                                          },
                              }
                  },
                  -- east outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowEast',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     bounding_cube.length-elemsize+eps,
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  {
                   attribute = {
                                 kind = 'refinement',
                                 level= finelevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {  
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,22*elemsize_fine,0.0},
                                                },
                                           origin={ --0.0, -0.875, 0.0},
                                                   -eps,
                                                   -- bounding_cube.length/8+2*elemsize_fine+eps,
                                                   -6*elemsize+eps,
                                                   ---bounding_cube.length/2+eps,
                                                   -eps},
                                                    },
                                          },
                  },
                  -- north outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowNorth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -elemsize+eps,
                                                    bounding_cube.length/8+4*elemsize+eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- south outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowSouth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -elemsize+eps,
                                                   -bounding_cube.length/8-4*elemsize-eps,
                                                   -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },

                 -- periodic in z-direction
                 {
                  attribute = {
                                kind = 'periodic',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'periodic',
                                object = 
                                         {
                                          plane1 = {
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,bounding_cube.length,0.0},
                                                          },
                                                     origin={-eps,-bounding_cube.length/2+eps,-eps},
                                                   },
                                          plane2 = {
                                                     vec= {
                                                            {bounding_cube.length,0.0,0.0},
                                                            {0.0,bounding_cube.length,0.0},
                                                          },
                                                     origin={-eps,-bounding_cube.length/2+eps,elemsize+eps},
                                                   },
                                         }
                             }
                 },

                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0.0,0.0,0.0 },
                                           --origin = {bounding_cube.length/2,0.0,0.0 },
                                        },
                             },
                  },
                }
	    
