require 'common'
-- physical parameter ---------------------------------------------------------
initial_condition = {
  density = 0.0, 
  velocityX = 0.0,
  velocityY = 0.0,
  pressure = 0.0, 
}
bg_dens = dens
bg_velX = velocityX
bg_velY = velocityY
bg_press = press

-- simulation controll parameter-----------------------------------------------
simulation_name='ateles_lineuler'
timing_file = 'timing_lineuler.res'

-- table for preCICE
precice = {
           accessor = 'Ateles_lineuler',
           configFile ='precice.xml',
          }

-- Restart  -------------------------------------------------------------------
restart = {
--  read  = './restart/lineuler/ateles_lineuler_header_200.000E-03.lua',
  write = './restart/lineuler/',
  time_control = {
    min = 0, 
    max = tmax, 
    interval = track_dt
  },
}

-- Tracking -------------------------------------------------------------------
--ply_sampling = { nlevels = 2}
tracking = {
  { -- GLobal VTK
    label = 'global',
    folder = './track/lineuler/',
    variable = {'density', 'velocity', 'pressure', 'completeState'},
    shape = {
      { kind = 'all',}
    },
    time_control = {min = 0, max = tmax, interval = track_dt},
    output={format = 'vtk'},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_lineuler/'

-- Variable system definintion-------------------------------------------------

variable = {
  -- add the background to varSys
  {
    name = 'bg_density',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_dens,  
  },
  {
    name = 'bg_velocity',
    ncomponents = 2,
    vartype = 'st_fun',
    st_fun =  {bg_velX, bg_velY}  
  },
  {
    name = 'bg_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_press,  
  },
  {
    name = 'coupling_acoustic',
    ncomponents = 4,
    vartype = 'st_fun',
    st_fun = { 
      predefined = 'precice',
      precice_mesh = 'Acoustic_Surface_lineuler',
      write_varname = {'density_lineuler', 
                       'velX_lineuler', 
                       'velY_lineuler', 
                       'pressure_lineuler'},
      read_varname = {'density_euler_acoustic', 
                      'velX_euler_acoustic', 
                      'velY_euler_acoustic', 
                      'pressure_euler_acoustic'},
    }          
   },
  -- write to precice
  {
    name = 'density_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'density','bg_density'},
    }          
  },
  {
    name = 'vel_lineuler',
    ncomponents = 2,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'velocity','bg_velocity'},
    }          
  },
  {
    name = 'velX_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = {'vel_lineuler'},
      input_varindex = {1}
    }          
  },
  {
    name = 'velY_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = {'vel_lineuler'},
      input_varindex = {2}
    }          
  },

  {
    name = 'pressure_lineuler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'pressure','bg_pressure'},
    }          
  },
  --read from precice
  {
    name = 'density_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {1}
    }          
  },
  {
    name = 'velX_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {2}
    }          
  },
  {
    name = 'velY_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {3}
    }          
  },
  {
    name = 'pressure_euler_acoustic',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling_acoustic',
      input_varindex = {4}
    }          
  },
  {
    name = 'per_density_euler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'density_euler_acoustic','bg_density'},
    }          
  },
  {
    name = 'velocity_euler',
    ncomponents = 2,
    vartype = 'operation',
    operation = {
      kind = 'combine',
      input_varname = {'velX_euler_acoustic','velY_euler_acoustic'},
    }          
  },
  {
    name = 'per_vel_euler',
    ncomponents = 2,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'velocity_euler','bg_velocity'},
    }          
  },
  {
    name = 'per_velX_euler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = {'per_vel_euler'},
      input_varindex = {1}
    }          
  },
  {
    name = 'per_velY_euler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = {'per_vel_euler'},
      input_varindex = {2}
    }          
  },
  {
    name = 'per_pressure_euler',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'pressure_euler_acoustic','bg_pressure'},
    }          
  },
}


-- Equation definitions -------------------------------------------------------
equation = {
  name = 'LinearEuler_2d',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  background = {
    density =  bg_dens,
    velocityX = bg_velX,
    velocityY = bg_velY,
    pressure = bg_press
  }
}

 -- Boundary definitions
boundary_condition = {
  {
    label = 'acoustic',
    kind = 'primitives',
    density = 'per_density_euler',
    velocityX = 'per_velX_euler', 
    velocityY = 'per_velY_euler',
    pressure = 'per_pressure_euler',
  }
  ,
  {
    label = 'outside',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0, 
    velocityY = 0.0,
    pressure = 0.0,
  }
}
