-- Use this file as template. Do not modify this file for running some testcases

outputname = 'lineuler'
outputpreview = true 
folder = 'mesh_lineuler/'

level = 8
maxlevel = level
minlevel = level

cubeLength = 32.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }


-- the element size of the largest elements (belonging to minlevel)
eps = bounding_cube.length/(2^level+1)
elemSize = bounding_cube.length/(2^level)

spatial_object = {
  {
    attribute = {kind = 'seed' },
    geometry = {
      kind   = 'canoND',
      object = {origin = {5.0,0.0,0.0} },
    },
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outside',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        only_surface = true,
        vec= {
          {16.0+2*eps,0.0,0.0},
          {0.0,16.0+2*eps,0.0},
          {0.0,0.0,elemSize+2*eps},
        },
        origin={-8.0-eps,-8.0-eps, -eps}
      },
    },
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'acoustic',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        vec= {
          {8.0-2*eps,0.0,0.0},
          {0.0,8.0-2*eps,0.0},
          {0.0,0.0,elemSize-2*eps},
        },
        origin={
          -4.0+eps,
          -4.0+eps,
          eps,
        },
      },
    },
  },
}
