--           2 
--          /
--       -------    
--      /      /|
--     /  5   / |
--     -------  | 4
--    |  |   |  |
-- 3  |  |   |  | 
--    |   ---|---
--    | /  6 | /
--    |/     |/
--     ------
--     /
--    1      
--       
--       4 is precice boundary
--
--
printRuntimeInfo = false
outputname= 'mesh_lineuler'
comment = 'mesh_lineuler'
minlevel = 6
folder = 'mesh_lineuler/'
level = minlevel
cubeLength = 64.0
--debug = {debugMode=true, debugFiles=true, debugMesh='debug/'}
bounding_cube = { origin = {-cubeLength/2, -cubeLength/2, -cubeLength/2}, 
                  length = cubeLength 
                }
elemSize = bounding_cube.length/(2^level)
eps=bounding_cube.length/(2^(level+1))

-------------------------------------------------------------------
 spatial_object = {
  { attribute = { kind = 'seed', label = 'seed', },
    geometry = {
      kind = 'canoND',
      object = { origin = { -15.0, 0.0, 0.0 },
     }
    }
  }, -- seed
  { attribute = {
      kind = 'boundary', label = 'top',
      level = level, calc_dist = false,
  },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (-30.0-eps), (-30.0-eps), 30.0+eps }, -- left down front 
        vec = { { (60.0+2*eps), 0.0, 0.0 },
               { 0.0, (60.0+2*eps), 0.0 },
        },
      } -- object
    },
  },
  --------------------------------------------
  { attribute = {
      kind = 'boundary', label = 'bottom',
      level = level, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (-30.0-eps), (-30.0-eps), -30.0-eps }, -- left down back
        vec = { { (60.0+2*eps), 0.0, 0.0 },
                { 0.0, (60.0+2*eps), 0.0 },
        },
      } -- object
    },
  },
  --------------------------------------------
  { attribute = {
      kind = 'boundary', label = 'west', --'wall_3'
      level = level, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (-30.0-eps), (-30.0-eps), -30-eps }, -- left, down, front
        vec = { { 0.0, 0.0, (60.+2*eps) },
                { 0.0, (60.0+2*eps), 0.0 },
        },
      } -- object
    },
  },
  --------------------------------------------
  { attribute = {
      kind = 'boundary', label = 'east',
      level = level, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (30.0+eps), (-30.0-eps), -30.-eps }, --right, down, front
        vec = { { 0.0, 0.0, (60.+2*eps) },
                { 0.0, (60.0+2*eps), 0.0 },
        },
      } -- object
    },
  }, 
  --------------------------------------------
  { attribute = {
      kind = 'boundary', label = 'north',
      level = level, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {(-30.0-eps), (30.0+eps),-30.0-eps }, -- left, up, front
        vec = { { (60.0+2*eps), 0.0, 0.0 },
                { 0.0, 0.0, (60.+2*eps) },
        },
      } -- object
    },
  }, 
  --------------------------------------------
  { attribute = {
      kind = 'boundary', label = 'south',
      level = level, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (-30.0-eps), (-30.0-eps), -30.0-eps }, -- left, down, front
        vec = { { (60.0+2*eps), 0.0, 0.0 },
                { 0.0, 0.0, (60.+2*eps) },
        },
      } -- object
    },
  }, 
  {
    attribute = {
      kind = 'boundary',
      label = 'euler',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (-10.0+eps), (-10.0+eps), (-10+eps) }, -- left, down, front
        vec= { {20.0-2*eps,0.0,0.0},
               {0.0,20.-2*eps,0.0},
               {0.0,0.0,20.-2*eps},
        },
      },
    }
  },
} -- spatial object
