--           2
--          /
--       -------
--      /      /|
--     /  5   / |
--     -------  | 4
--    |  |   |  |
-- 3  |  |   |  |
--    |   ---|---
--    | /  6 | /
--    |/     |/
--     ------
--     /
--    1
--
--       4 is precice boundary
--
--
printRuntimeInfo = false
outputname= 'mesh_right'
comment = 'mesh_right'
minlevel = 4
folder = 'mesh_right/'
level = minlevel
---debug = {debugMode=true, debugFiles=true, debugMesh='debug/'}
length = 8.0
dx = length/(2^level)
bounding_cube = {
  origin = {-4.0, -4.0, -4.0-dx/2},
  length = length
}
-------------------------------------------------------------------
spatial_object = {
  {
    attribute = {
      kind = 'seed',
      label = 'seed'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { 1.0, 0.0, 0.0 },
      }
    }
  }, -- seed
  {
    attribute = {
      kind = 'boundary',
      label = 'top',
      level = level,
      calc_dist = false
  },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (0.0-dx), (-2.0-dx), (-dx-dx/2.0) }, -- left down front
        vec = {
          { (2.0+dx*2), 0.0, 0.0 },
          { 0.0, (4.0+dx*2), 0.0 }
        }
      } -- object
    }
  },
  --------------------------------------------
  {
    attribute = {
      kind = 'boundary',
      label = 'bottom',
      level = level,
      calc_dist = false
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (0.0-dx), (-2.0-dx), dx+dx/2.0 }, -- left down back
        vec = {
          { (2.0+dx*2), 0.0, 0.0 },
          { 0.0, (4.0+dx*2), 0.0 }
        }
      } -- object
    }
  },
  --------------------------------------------
  {
    attribute = {
      kind = 'boundary',
      label = 'west', --'wall_3'
      level = level,
      calc_dist = false
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (0.0-dx), (-2.0-dx),(-dx-dx/2.0) }, -- left, down, front
        vec = {
          { 0.0, 0.0, (dx+dx*2.0) },
          { 0.0, (4.0+dx*2), 0.0 }
        }
      } -- object
    }
  },
  --------------------------------------------
  {
    attribute = {
      kind = 'boundary',
      label = 'east',
      level = level,
      calc_dist = false
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (2.0+dx), (-2.0-dx), ( -dx-dx/2.0) }, --right, down, front
        vec = {
          { 0.0, 0.0, (dx+dx*2.0) },
          { 0.0, (4.0+dx*2.0), 0.0 }
        }
      } -- object
    }
  },
  --------------------------------------------
  {
    attribute = {
      kind = 'boundary',
      label = 'north',
      level = level,
      calc_dist = false
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {(0.0-dx), (2.0+dx),(-dx-dx/2.0) }, -- left, up, front
        vec = {
          { (2.0+dx*2.0), 0.0, 0.0 },
          { 0.0, 0.0, (dx+dx*2.0) }
        }
      } -- object
    }
  },
  --------------------------------------------
  {
    attribute = {
      kind = 'boundary',
      label = 'south',
      level = level,
      calc_dist = false
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { (0.0-dx), (-2.0-dx), (-dx-dx/2.0) }, -- left, down, front
        vec = {
          { (2.0+dx*2.0), 0.0, 0.0 },
          { 0.0, 0.0, (dx+dx*2.0) }
        }
      } -- object
    }
  }
} -- spatial object
