---------------------------------------------------------------------------------------------------
-- PARAMETER
endtime = 0.01
interval = 0.001 
---------------------------------------------------------------------------------------------------
-- DEBUG OPTIONS
--debug = { 
--         debugMode = true, 
--         debugFiles = true,
--         verbose = true,
--         dumpTreeIDs = true,
--         dumpDependencies = true,
--         checkSteps = true,
--         dumpState = true,
--         debugMesh = './debug/mesh_', 
--         debugStates = { 
--                        write = {
--                                 folder    = './debug/',    -- the folder for the debug mesh 
--                                 interval  = 0.09,    -- dump restart file interval
--                                 tmin      = 0,           -- first timestep to output
--                                 tmax      = 0.001      -- last timestep to output
--                                }
--                       }
--        }
---------------------------------------------------------------------------------------------------
-- GLOBAL SIMULATION OPTIONS
simulation = {
              name = '',
              final_time = endtime
             }
---------------------------------------------------------------------------------------------------
-- MESH DEFINITION
mesh = 'mesh/'       -- (default = 'mesh/')
---------------------------------------------------------------------------------------------------
-- RESTART SETTINGS 
restart = {

           write = 'restart/'.. os.getenv('MESH')..'/'.. os.getenv('DENSITY') ..'_'.. os.getenv('EQUATION') ..'_'.. os.getenv('SCHEME') ..'_'.. os.getenv('NPROCS')..'/',
           time = { useIterations = false, min = 0, max = endtime, interval = interval } 
          }   
--------------------------------------------------------------------------------------------------
require ('./mesh/seeder_'..os.getenv('MESH'))
---------------------------------------------------------------------------------------------------
require ('./config/mesh/'..os.getenv('MESH'))
---------------------------------------------------------------------------------------------------
require ('./config/density/'..os.getenv('DENSITY'))
---------------------------------------------------------------------------------------------------
require ('./config/equation/'..os.getenv('EQUATION'))
--------------------------------------------------------------------------------------------------
require ('./config/scheme/'..os.getenv('SCHEME'))
---------------------------------------------------------------------------------------------------
