## Simulation Name
simulation_name='parallel_verification'

echo 
echo 'Harvester processing script'
echo 
echo  'Checking for binary...'
if [ -e "${harvester}" ]; then
  echo 'Running with '${harvester}
else
  echo  'Binary not found. Aborting ...'
  exit
fi
echo 
if [ "X$@" = "X" ]; then
  echo  'Please provide the files to process as arguments'
  echo  'Example:'
  echo 
  echo  '  ./harvest.sh tracking/*.lua'
  echo 
  echo  'Aborting ...'
  exit
fi

mkdir $harvest/$test_
mkdir $output_folder

echo 'Restart folder    :' ${restart_folder}
#echo 'deleting old output folder' ${output_folder}
#rm -rf $output_folder
#mkdir $output_folder

restartfile_list=$@ #`ls ${restart_folder}/*.lua`‚
echo 'Processing ' ${restartfile_list}

x=0
for restartfile in $restartfile_list; do
  echo 
  echo Running Harvester with Restart header $restartfile
  echo 
  export RESTARTFOLDER="./$restartfile"
  export RESTARTHEADER="$restartfile"
  export output_folder="$output_folder"
  export SIMULATIONNAME="$simulation_name"_$x
  $harvester $series_lua
  echo 
  echo
  x=$(($x+1))
done
