# Run Musubi with different number of processes and check the restart file, 
# if it is identical by using the checksum (md5sum)
# We run the code for a set of defined processes (procs)
# and check the md5sum of the restart files
# by default this script checks last restart write and read files 
# i.e files written at tmax in config file

executable='../../../build/debug/ateles'
timing='timing.res' 
restart_write_folder='restart/'
output='results/'

run_harvester='false'


#mesh='test1 test2 test3 test4 test5 test6 test7 test8 test9 test10 test11 test12 test13 test 14 periodic boundaries'
#density='constant predefined_gauss_pulse predefined_parabol_2d predefined_parabol_3d'
#equations='euler navierstokes'
#schemes='muscl_euler weno_euler weno_rk'
#procs='1 2 4 8'  

mesh='test12'
density='predefined_gauss_pulse'
equations='euler'
schemes='muscl_euler'
procs='1 8'  

#compare restart files at the following points in time  
#restart='01 02 03 04 05 10 90'

errorCount=

for MESH in ${mesh}; do  
  
  seeder=../../../../seeder/
  ./${seeder}build/debug/seeder mesh/seeder_$MESH.lua > log/seeder.log
  echo "$MESH" >> ${timing} 
  echo "------" >> ${timing} 
 
  # execute for all procs
  for DENSITY in $density; do
    for EQUATION in $equations; do
      for SCHEME in $schemes; do
  
        rm ${output}/$MESH/${DENSITY}_${EQUATION}_${SCHEME}
        mkdir -p ${output}/$MESH/
        result="${output}/$MESH/${DENSITY}_${EQUATION}_${SCHEME}"
        echo "$MESH" > ${result}
  
        for NPROCS in $procs; do
    
          name="${DENSITY}_${EQUATION}_${SCHEME}_${NPROCS}"
          restart_folder="${restart_write_folder}/$MESH/${name}/"
  
          tracking_folder="tracking/$MESH/$name/"        
          
          rm -rf  ${restart_folder}
          mkdir ${restart_write_folder}/$MESH/
          mkdir ${restart_folder}
          mkdir output/$MESH/
          mkdir output/$MESH/${DENSITY}_${EQUATION}_${SCHEME}_${NPROCS}
          mkdir tracking/$MESH/
          mkdir ${tracking_folder}
          
          echo "------" >> ${result}
          echo "Running ${name}"
          echo "${name}" >> ${timing}
          echo "${name}" >> ${result}
          echo "------" >> ${result} 
          
          mkdir log/$MESH/
          logfile="log/$MESH/${name}.log"
          export MESH="${MESH}" EQUATION="$EQUATION" DENSITY="$DENSITY" SCHEME="$SCHEME" NPROCS="$NPROCS"
          MESH="${MESH}" EQUATION="$EQUATION" DENSITY="$DENSITY" SCHEME="$SCHEME" NPROCS="$NPROCS" mpirun -np ${NPROCS} ${executable} ateles_write.lua #> $logfile
          errorcode=$?
          if [ $errorcode -ne 0 ]; then 
              echo "$(tput setaf 1)Error$(tput sgr0): ateles returned with status $errorcode, see ${logfile}"
              exit 
          fi
    
          #file name to store md5sum output from restart write
          sumname="restart/${name}"
          
          # generate restart write md5 sums
          echo 'Storing restart write md5sum to ' $sumname
          md5sum ${restart_folder}*.lsb > ${sumname}.md5
          md5sum ${restart_folder}*00.000E+00.lsb > ${sumname}_00.md5
          tail -1 ${sumname}.md5 | awk '{print $1}' > restart/lastLine_write_${name}
          tail -1 ${sumname}_00.md5 | awk '{print $1}' > restart/lastLine_write_00_${name}
     
          echo  "Now testing difference in the last line between WRITE 1 proc and WRITE ${NPROCS} procs:"
          echo  "WRITE 1 proc vs. WRITE ${NPROCS} procs: (lastLine_write_${DENSITY}_${EQUATION}_${SCHEME}_1 vs. lastLine_write_${name}" >> ${result}
          difference=`diff restart/lastLine_write_${DENSITY}_${EQUATION}_${SCHEME}_1 restart/lastLine_write_${name}`
          if [ "X$difference" = "X" ]; then
            echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
            echo "No difference found. OK" >> ${result}
          else
            error=1
            errorCount=`expr $errorCount + 1`
            echo "$(tput setaf 1)Error$(tput sgr0): Difference found between ${nprocs} and serial:"
            echo "Difference found. ERROR <-------------------------------" >> ${result}
            echo ${difference}
          fi
  
          echo  "Now testing difference in the last line between WRITE 1 proc and WRITE ${NPROCS} procs (AFTER RESTART 00):"
          echo  "AFTER 00: WRITE 1 proc vs. WRITE ${NPROCS} procs:" >> ${result}
          difference=`diff restart/lastLine_write_00_${DENSITY}_${EQUATION}_${SCHEME}_1 restart/lastLine_write_00_${name}`
          if [ "X$difference" = "X" ]; then
            echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
            echo "No difference found. OK" >> ${result}
          else
            error=1
            errorCount=`expr $errorCount + 1`
            echo "$(tput setaf 1)Error$(tput sgr0): Difference found between ${nprocs} and serial:"
            echo "Difference found. ERROR <-------------------------------" >> ${result}
            echo ${difference}
          fi
  
          for RESTART in $restart; do
            md5sum ${restart_folder}*${RESTART}.000E-03.lsb > ${sumname}_${RESTART}.md5
            tail -1 ${sumname}_${RESTART}.md5 | awk '{print $1}' > restart/lastLine_write_${RESTART}_${name}
  
            echo  "Now testing difference in the last line between WRITE 1 proc and WRITE ${NPROCS} procs (AFTER RESTART ${RESTART}):"
            echo  "AFTER ${RESTART}: WRITE 1 proc vs. WRITE ${NPROCS} procs:" >> ${result}
            difference=`diff restart/lastLine_write_${RESTART}_${DENSITY}_${EQUATION}_${SCHEME}_1 restart/lastLine_write_${RESTART}_${name}`
            if [ "X$difference" = "X" ]; then
              echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
              echo "No difference found. OK" >> ${result}
            else
              error=1
              errorCount=`expr $errorCount + 1`
              echo "$(tput setaf 1)Error$(tput sgr0): Difference found between ${nprocs} and serial:"
            echo "Difference found. ERROR <-------------------------------" >> ${result}
              echo ${difference}
            fi
          done
          echo  >> ${result}
        
          if $run_harvester eq 'true'; then  
            harvester='../../../../harvester/build/debug/harvester'
            series_lua=harvest/harvest_series.lua
            harvest="harvest/"
            test_="$MESH"
            case="$name"
            restart_folder="$restart_folder"
            output_folder="$harvest/$test_/$case/"
  
            harvester=$harvester series_lua=$series_lua harvest=$harvest test_=$test_ case=$case restart_folder=$restart_folder output_folder=$output_folder sh harvest/harvest_.sh $restart_folder/*.lua > log/harvest.lua
          fi

        done
        echo "---" >> ${result}
        echo "---" >> ${timing} 
      done
    done
  done
done

rm restart/lastLine* 
rm restart/*.md5

if [ "$errorCount" = "0" ]; then
  echo "Done. Everything $(tput setaf 2)OK$(tput sgr0)"
  exit 0
else
  echo "Done. $(tput setaf 1)$errorCount errors$(tput sgr0) occured."
  exit 1
fi

