# Run Musubi with different number of processes and check the restart file, 
# if it is identical by using the checksum (md5sum)
# We run the code for a set of defined processes (procs)
# and check the md5sum of the restart files
# by default this script checks last restart write and read files 
# i.e files written at tmax in config file

executable=../../../build/debug/ateles

restart_folder='restart/'
restart_folder_ref='restart_ref/'
restart_Readfolder='restart_read/'

# delete existing restart folders
rm -rf  ${restart_folder} ${restart_Readfolder}

string=''
counter=0

#procs='1 2 3 4 5 6 7 8 9 10 11 12 33 35 36 66 67'
procs='1 2 4'

# execute for all procs (WRITE md5 sums)
for nprocs in $procs;
do
  # generate restart WRITE md5 sums
  counter=$((counter+1))
  mkdir ${restart_folder}
  
  mpirun -np ${nprocs} ${executable} ateles_euler_write.lua
  if [ $? -ne 0 ]; 
    then 
      echo Return status: $?
      exit 
  fi
  #file name to store md5sum output from restart write
  sumname=write_${nprocs}.md5

  echo 'Storing restart write md5sum to ' $sumname
  md5sum ${restart_folder}/*.lsb > ${sumname}
  #md5sum ${restart_folder}/*.lsb | awk '{print $1}' | tail -1 > ${sumname}
  #mv fort.66 write_${nprocs}.out
  

  if [ $counter -eq 1 ]; then
    echo 'setting restart write reference MD5sum'
    firstwritesum=$sumname
    tail -1 $sumname | awk '{print $1}' > ref_lastLine
    mv ${restart_folder} ${restart_folder_ref}
  else
    # Delete folders
    rm -rf ${restart_folder}
  fi
done
  

mv ${restart_folder_ref} ${restart_folder}
# execute for all procs (READ md5 sums)
for nprocs in $procs;
do
  counter=$((counter+1))

  # generate restart READ md5 sums
  mkdir ${restart_Readfolder}
  mpirun -np ${nprocs} ${executable} ateles_euler_read.lua
  if [ $? -ne 0 ]; 
    then 
      echo Return status: $?
      exit 
  fi
  #file name to store md5sum output from restart read
  sumname=read_${nprocs}.md5

  echo 'Storing restart read md5sum to '$sumname
  md5sum ${restart_Readfolder}/*.lsb > ${sumname}
  #mv fort.66 read_${nprocs}.out

  if [ $counter -eq 1 ]; then
    echo 'setting restart read reference MD5sum'
    firstreadsum=$sumname
  fi

  # Delete folders
  rm -rf ${restart_Readfolder}
done
rm -rf ${restart_folder}

echo 'testing the difference between the restart write from one proc with more proc'
counter=0
for nprocs in $procs;
do
  counter=$((counter+1))
  string="${firstwritesum} and write_${nprocs}.md5"
  
  tail -1 write_${nprocs}.md5 | awk '{print $1}' > lastLine 

  if [ $counter -eq 1 ]; then
    echo 'restart write from one proc is set as a reference md5sum:' ${firstwritesum}
  else
    echo  "Now testing difference in the last line between $string (WRITE 1Proc vs. WRITE ${nprocs}) :"
    difference=`diff ref_lastLine lastLine`
    if [ "X$difference" = "X" ]; then
      echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
    else
      echo "$(tput setaf 1)Error$(tput sgr0): Difference found between ${nprocs} and 1 proc:"
      echo ${difference}
    fi
  fi
done
echo
echo
echo 'testing the difference between the restart write from one proc with restart read-write with one and more proc'
counter=0
for nprocs in $procs;
do
  counter=$((counter+1))

  string="${firstwritesum} and read_${nprocs}.md5"

  tail -1 read_${nprocs}.md5 | awk '{print $1}' > lastLine
#  if [ $counter -eq 1 ]; then
#    echo 'reference md5sum'
#  else
  echo  "Now testing difference in the last line between ${string} (READ {$nprocs} vs. WRITE 1proc) :"
  difference=`diff ref_lastLine lastLine`
  if [ "X$difference" = "X" ]; then
    echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
  else
    echo "$(tput setaf 1)Error$(tput sgr0): Difference found:"
    echo ${difference}
  fi
#  fi
done
echo 
echo 
echo "Done. "

rm ref_lastLine lastLine
